/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.impl.decorator.processor;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import jakarta.annotation.Priority;
import jakarta.decorator.Decorator;
import jakarta.decorator.Delegate;
import jakarta.inject.Inject;
import lombok.Generated;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;

@Decorator
@Priority(value=200)
public class CdiRequestContextDecorator<KIn, VIn, KOut, VOut>
implements Processor<KIn, VIn, KOut, VOut> {
    private final Processor<KIn, VIn, KOut, VOut> delegate;
    private final ArcContainer container;

    @Inject
    public CdiRequestContextDecorator(@Delegate Processor<KIn, VIn, KOut, VOut> delegate) {
        this(delegate, Arc.container());
    }

    public void process(Record<KIn, VIn> record) {
        if (this.container.requestContext().isActive()) {
            this.delegate.process(record);
        } else {
            this.container.requestContext().activate();
            try {
                this.delegate.process(record);
            }
            finally {
                this.container.requestContext().terminate();
            }
        }
    }

    @Generated
    CdiRequestContextDecorator(Processor<KIn, VIn, KOut, VOut> delegate, ArcContainer container) {
        this.delegate = delegate;
        this.container = container;
    }

    @Generated
    public void init(ProcessorContext<KOut, VOut> context) {
        this.delegate.init(context);
    }

    @Generated
    public void close() {
        this.delegate.close();
    }

    private static interface Excludes {
        public <KIn, VIn> void process(Record<KIn, VIn> var1);
    }
}

