/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.impl.errors;

import jakarta.enterprise.context.ApplicationScoped;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;

@ApplicationScoped
public class DlqMetadataHandler {
    public Headers withMetadata(Headers headers, String topic, Integer partition, Throwable error) {
        RecordHeaders headersWithDlq = new RecordHeaders(headers.toArray());
        this.addMetadata((Headers)headersWithDlq, topic, partition, error);
        return headersWithDlq;
    }

    public void addMetadata(Headers headers, String topic, Integer partition, Throwable error) {
        if (error.getMessage() != null) {
            headers.add("dead-letter-reason", error.getMessage().getBytes(StandardCharsets.UTF_8));
        }
        if (error.getCause() != null) {
            headers.add("dead-letter-cause", error.getCause().getClass().getName().getBytes(StandardCharsets.UTF_8));
        }
        headers.add("dead-letter-topic", topic.getBytes(StandardCharsets.UTF_8));
        if (partition != null) {
            headers.add("dead-letter-partition", Integer.toString(partition).getBytes(StandardCharsets.UTF_8));
        }
    }
}

