/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.impl.health;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.apache.kafka.streams.KafkaStreams;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class RebalancingTopicHealthCheck
implements HealthCheck {
    @Inject
    KafkaStreams kafkaStreams;

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder responseBuilder = HealthCheckResponse.named((String)"Kafka Streams state health check");
        try {
            KafkaStreams.State state = this.kafkaStreams.state();
            responseBuilder.status(state == KafkaStreams.State.RUNNING).withData("state", state.name());
        }
        catch (Exception e) {
            responseBuilder.down().withData("technical_error", e.getMessage());
        }
        return responseBuilder.build();
    }
}

