/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.spi;

import io.quarkiverse.kafkastreamsprocessor.spi.properties.DlqConfig;
import io.quarkiverse.kafkastreamsprocessor.spi.properties.GlobalDlqConfig;
import io.quarkiverse.kafkastreamsprocessor.spi.properties.InputConfig;
import io.quarkiverse.kafkastreamsprocessor.spi.properties.KStreamsProcessorConfig;
import io.quarkiverse.kafkastreamsprocessor.spi.properties.OutputConfig;
import io.quarkiverse.kafkastreamsprocessor.spi.properties.RetryConfig;
import io.quarkiverse.kafkastreamsprocessor.spi.properties.SinkConfig;
import io.quarkiverse.kafkastreamsprocessor.spi.properties.SourceConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.eclipse.microprofile.config.Config;

class KStreamsProcessorConfigGenerator {
    private static final Pattern P_SOURCE = Pattern.compile("kafkastreamsprocessor\\.input\\.sources\\.(.*)\\.topics");
    private static final Pattern P_SINK = Pattern.compile("kafkastreamsprocessor\\.output\\.sinks\\.(.*)\\.topic");

    KStreamsProcessorConfigGenerator() {
    }

    static KStreamsProcessorConfig buildConfig(Config config) {
        InputConfigImpl input = new InputConfigImpl(config.getOptionalValue("kafkastreamsprocessor.input.topic", String.class), config.getOptionalValues("kafkastreamsprocessor.input.topics", String.class));
        KStreamsProcessorConfigGenerator.fillSources(config, input);
        OutputConfigImpl output = new OutputConfigImpl(config.getOptionalValue("kafkastreamsprocessor.output.topic", String.class));
        KStreamsProcessorConfigGenerator.fillSinks(config, output);
        return new KStreamsProcessorConfigImpl(input, output);
    }

    private static void fillSources(Config config, InputConfigImpl input) {
        for (String property : config.getPropertyNames()) {
            Matcher matcher = P_SOURCE.matcher(property);
            if (!matcher.matches()) continue;
            String sourceName = matcher.group(1);
            String topics = (String)config.getValue(property, String.class);
            SourceConfigImpl sourceConfig = new SourceConfigImpl(List.of(topics.split(",")));
            if (sourceName.contains(".")) {
                throw new IllegalStateException("Parsed source name has a dot: " + sourceName);
            }
            input.sources().put(sourceName, sourceConfig);
        }
    }

    private static void fillSinks(Config config, OutputConfigImpl output) {
        for (String property : config.getPropertyNames()) {
            Matcher matcher = P_SINK.matcher(property);
            if (!matcher.matches()) continue;
            String sinkName = matcher.group(1);
            String topic = (String)config.getValue(property, String.class);
            SinkConfigImpl sinkConfig = new SinkConfigImpl(topic);
            if (sinkName.contains(".")) {
                throw new IllegalStateException("Parsed sink name has a dot: " + sinkName);
            }
            output.sinks().put(sinkName, sinkConfig);
        }
    }

    private static class InputConfigImpl
    implements InputConfig {
        private final Optional<String> topic;
        private final Optional<List<String>> topics;
        private final Map<String, SourceConfig> sources = new HashMap<String, SourceConfig>();

        @Generated
        public InputConfigImpl(Optional<String> topic, Optional<List<String>> topics) {
            this.topic = topic;
            this.topics = topics;
        }

        @Override
        @Generated
        public Optional<String> topic() {
            return this.topic;
        }

        @Override
        @Generated
        public Optional<List<String>> topics() {
            return this.topics;
        }

        @Override
        @Generated
        public Map<String, SourceConfig> sources() {
            return this.sources;
        }
    }

    private static class OutputConfigImpl
    implements OutputConfig {
        private final Optional<String> topic;
        private final Map<String, SinkConfig> sinks = new HashMap<String, SinkConfig>();

        @Generated
        public OutputConfigImpl(Optional<String> topic) {
            this.topic = topic;
        }

        @Override
        @Generated
        public Optional<String> topic() {
            return this.topic;
        }

        @Override
        @Generated
        public Map<String, SinkConfig> sinks() {
            return this.sinks;
        }
    }

    private static class KStreamsProcessorConfigImpl
    implements KStreamsProcessorConfig {
        private final InputConfig input;
        private final OutputConfig output;
        private final DlqConfig dlq = null;
        private final GlobalDlqConfig globalDlq = null;
        private final String errorStrategy = "";
        private final RetryConfig retry = null;

        @Generated
        public KStreamsProcessorConfigImpl(InputConfig input, OutputConfig output) {
            this.input = input;
            this.output = output;
        }

        @Override
        @Generated
        public InputConfig input() {
            return this.input;
        }

        @Override
        @Generated
        public OutputConfig output() {
            return this.output;
        }

        @Override
        @Generated
        public DlqConfig dlq() {
            return this.dlq;
        }

        @Override
        @Generated
        public GlobalDlqConfig globalDlq() {
            return this.globalDlq;
        }

        @Override
        @Generated
        public String errorStrategy() {
            return this.errorStrategy;
        }

        @Override
        @Generated
        public RetryConfig retry() {
            return this.retry;
        }
    }

    private static class SourceConfigImpl
    implements SourceConfig {
        private final List<String> topics;

        @Generated
        public SourceConfigImpl(List<String> topics) {
            this.topics = topics;
        }

        @Override
        @Generated
        public List<String> topics() {
            return this.topics;
        }
    }

    private static class SinkConfigImpl
    implements SinkConfig {
        private final String topic;

        @Generated
        public SinkConfigImpl(String topic) {
            this.topic = topic;
        }

        @Override
        @Generated
        public String topic() {
            return this.topic;
        }
    }
}

