/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.spi;

import io.quarkiverse.kafkastreamsprocessor.spi.KStreamsProcessorConfigGenerator;
import io.quarkiverse.kafkastreamsprocessor.spi.properties.KStreamsProcessorConfig;
import io.quarkiverse.kafkastreamsprocessor.spi.properties.SinkConfig;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.microprofile.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class SinkToTopicMappingBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SinkToTopicMappingBuilder.class);
    String DEFAULT_SINK_NAME = "emitter-channel";
    private final KStreamsProcessorConfig extensionConfiguration;

    @Inject
    public SinkToTopicMappingBuilder(KStreamsProcessorConfig extensionConfiguration) {
        this.extensionConfiguration = extensionConfiguration;
    }

    public SinkToTopicMappingBuilder(Config config) {
        this(KStreamsProcessorConfigGenerator.buildConfig(config));
    }

    public Map<String, String> sinkToTopicMapping() {
        Optional<String> singleOutputTopic;
        Map<String, String> sinkToTopicMapping = this.buildMapping();
        if (sinkToTopicMapping.isEmpty() && (singleOutputTopic = this.extensionConfiguration.output().topic()).isPresent()) {
            return Map.of(this.DEFAULT_SINK_NAME, singleOutputTopic.get());
        }
        return sinkToTopicMapping;
    }

    private Map<String, String> buildMapping() {
        HashMap<String, String> sinkToTopicMapping = new HashMap<String, String>();
        for (Map.Entry<String, SinkConfig> sinkEntry : this.extensionConfiguration.output().sinks().entrySet()) {
            String topicName = sinkEntry.getValue().topic();
            if (topicName == null || topicName.isEmpty()) continue;
            sinkToTopicMapping.put(sinkEntry.getKey(), topicName);
        }
        return sinkToTopicMapping;
    }
}

