/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.spi;

import io.quarkiverse.kafkastreamsprocessor.spi.KStreamsProcessorConfigGenerator;
import io.quarkiverse.kafkastreamsprocessor.spi.properties.KStreamsProcessorConfig;
import io.quarkiverse.kafkastreamsprocessor.spi.properties.SourceConfig;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.microprofile.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class SourceToTopicsMappingBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SourceToTopicsMappingBuilder.class);
    String DEFAULT_SOURCE_NAME = "receiver-channel";
    private final KStreamsProcessorConfig extensionConfiguration;

    @Inject
    public SourceToTopicsMappingBuilder(KStreamsProcessorConfig extensionConfiguration) {
        this.extensionConfiguration = extensionConfiguration;
    }

    public SourceToTopicsMappingBuilder(Config config) {
        this(KStreamsProcessorConfigGenerator.buildConfig(config));
    }

    public Map<String, String[]> sourceToTopicsMapping() {
        Map<String, String[]> sourceToTopicMapping = this.buildMapping();
        if (sourceToTopicMapping.isEmpty()) {
            Optional<List<String>> inputTopicList = this.extensionConfiguration.input().topics();
            if (inputTopicList.isPresent()) {
                return Map.of(this.DEFAULT_SOURCE_NAME, inputTopicList.get().toArray(new String[0]));
            }
            Optional<String> singleInputTopic = this.extensionConfiguration.input().topic();
            if (singleInputTopic.isPresent()) {
                return Map.of(this.DEFAULT_SOURCE_NAME, new String[]{singleInputTopic.get()});
            }
        }
        return sourceToTopicMapping;
    }

    private Map<String, String[]> buildMapping() {
        HashMap<String, String[]> sourceToTopicMapping = new HashMap<String, String[]>();
        for (Map.Entry<String, SourceConfig> sourceEntry : this.extensionConfiguration.input().sources().entrySet()) {
            List<String> topicNames = sourceEntry.getValue().topics();
            if (topicNames == null || topicNames.isEmpty()) continue;
            sourceToTopicMapping.put(sourceEntry.getKey(), topicNames.toArray(new String[0]));
        }
        return sourceToTopicMapping;
    }
}

