/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.ai.gemini.deployment;

import io.quarkiverse.langchain4j.ModelName;
import io.quarkiverse.langchain4j.ai.gemini.deployment.GeminiBuildConfig;
import io.quarkiverse.langchain4j.ai.runtime.gemini.AiGeminiRecorder;
import io.quarkiverse.langchain4j.ai.runtime.gemini.config.LangChain4jAiGeminiConfig;
import io.quarkiverse.langchain4j.deployment.DotNames;
import io.quarkiverse.langchain4j.deployment.LangChain4jDotNames;
import io.quarkiverse.langchain4j.deployment.items.ChatModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.EmbeddingModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedChatModelProviderBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedEmbeddingModelCandidateBuildItem;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderOverrideBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterOverrideBuildItem;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.List;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class AiGeminiProcessor {
    private static final String FEATURE = "langchain4j-ai-gemini";
    private static final String PROVIDER = "ai-gemini";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public void providerCandidates(BuildProducer<ChatModelProviderCandidateBuildItem> chatProducer, BuildProducer<EmbeddingModelProviderCandidateBuildItem> embeddingProducer, GeminiBuildConfig config) {
        if (config.chatModel().enabled().isEmpty() || ((Boolean)config.chatModel().enabled().get()).booleanValue()) {
            chatProducer.produce((BuildItem)new ChatModelProviderCandidateBuildItem(PROVIDER));
        }
        if (config.embeddingModel().enabled().isEmpty() || config.embeddingModel().enabled().get().booleanValue()) {
            embeddingProducer.produce((BuildItem)new EmbeddingModelProviderCandidateBuildItem(PROVIDER));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void generateBeans(AiGeminiRecorder recorder, List<SelectedChatModelProviderBuildItem> selectedChatItem, List<SelectedEmbeddingModelCandidateBuildItem> selectedEmbedding, LangChain4jAiGeminiConfig config, BuildProducer<SyntheticBeanBuildItem> beanProducer) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator builder;
        String configName;
        for (SelectedChatModelProviderBuildItem selectedChatModelProviderBuildItem : selectedChatItem) {
            if (!PROVIDER.equals(selectedChatModelProviderBuildItem.getProvider())) continue;
            configName = selectedChatModelProviderBuildItem.getConfigName();
            Function chatModel = recorder.chatModel(config, configName);
            builder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)LangChain4jDotNames.CHAT_MODEL).setRuntimeInit().defaultBean()).scope(ApplicationScoped.class)).addInjectionPoint((Type)ParameterizedType.create((DotName)DotNames.CDI_INSTANCE, (Type[])new Type[]{ClassType.create((DotName)DotNames.CHAT_MODEL_LISTENER)}, null), new AnnotationInstance[0])).addInjectionPoint((Type)ParameterizedType.create((DotName)DotNames.CDI_INSTANCE, (Type[])new Type[]{ClassType.create((DotName)DotNames.MODEL_AUTH_PROVIDER)}, null), new AnnotationInstance[0])).createWith(chatModel);
            this.addQualifierIfNecessary(builder, configName);
            beanProducer.produce((BuildItem)builder.done());
        }
        for (SelectedEmbeddingModelCandidateBuildItem selectedEmbeddingModelCandidateBuildItem : selectedEmbedding) {
            if (!PROVIDER.equals(selectedEmbeddingModelCandidateBuildItem.getProvider())) continue;
            configName = selectedEmbeddingModelCandidateBuildItem.getConfigName();
            Function embeddingModel = recorder.embeddingModel(config, configName);
            builder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)LangChain4jDotNames.EMBEDDING_MODEL).setRuntimeInit().defaultBean()).unremovable()).scope(ApplicationScoped.class)).addInjectionPoint((Type)ParameterizedType.create((DotName)DotNames.CDI_INSTANCE, (Type[])new Type[]{ClassType.create((DotName)DotNames.CHAT_MODEL_LISTENER)}, null), new AnnotationInstance[0])).addInjectionPoint((Type)ParameterizedType.create((DotName)DotNames.CDI_INSTANCE, (Type[])new Type[]{ClassType.create((DotName)DotNames.MODEL_AUTH_PROVIDER)}, null), new AnnotationInstance[0])).createWith(embeddingModel);
            this.addQualifierIfNecessary(builder, configName);
            beanProducer.produce((BuildItem)builder.done());
        }
    }

    private void addQualifierIfNecessary(SyntheticBeanBuildItem.ExtendedBeanConfigurator builder, String configName) {
        if (!NamedConfigUtil.isDefault((String)configName)) {
            builder.addQualifier(AnnotationInstance.builder(ModelName.class).add("value", configName).build());
        }
    }

    @BuildStep
    public void deprioritizeJsonb(Capabilities capabilities, BuildProducer<MessageBodyReaderOverrideBuildItem> readerOverrideProducer, BuildProducer<MessageBodyWriterOverrideBuildItem> writerOverrideProducer) {
        if (capabilities.isPresent("io.quarkus.rest.client.reactive.json.jsonb")) {
            readerOverrideProducer.produce((BuildItem)new MessageBodyReaderOverrideBuildItem("org.jboss.resteasy.reactive.server.jsonb.JsonbMessageBodyReader", 5001, true));
            writerOverrideProducer.produce((BuildItem)new MessageBodyWriterOverrideBuildItem("org.jboss.resteasy.reactive.server.jsonb.JsonbMessageBodyWriter", 5001, true));
        }
    }
}

