/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.ai.runtime.gemini;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ResponseFormatType;
import dev.langchain4j.model.chat.request.json.JsonEnumSchema;
import dev.langchain4j.model.chat.request.json.JsonSchema;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import io.quarkiverse.langchain4j.ai.runtime.gemini.AiGeminiRestApi;
import io.quarkiverse.langchain4j.gemini.common.ContentMapper;
import io.quarkiverse.langchain4j.gemini.common.FinishReasonMapper;
import io.quarkiverse.langchain4j.gemini.common.GenerateContentRequest;
import io.quarkiverse.langchain4j.gemini.common.GenerateContentResponse;
import io.quarkiverse.langchain4j.gemini.common.GenerateContentResponseHandler;
import io.quarkiverse.langchain4j.gemini.common.GenerationConfig;
import io.quarkiverse.langchain4j.gemini.common.SchemaMapper;
import io.quarkus.rest.client.reactive.QuarkusRestClientBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.api.LoggingScope;

public class AiGeminiChatLanguageModel
implements ChatLanguageModel {
    private final AiGeminiRestApi.ApiMetadata apiMetadata;
    private final AiGeminiRestApi restApi;
    private final Double temperature;
    private final Integer maxOutputTokens;
    private final Integer topK;
    private final Double topP;
    private final ResponseFormat responseFormat;

    private AiGeminiChatLanguageModel(Builder builder) {
        this.temperature = builder.temperature;
        this.maxOutputTokens = builder.maxOutputTokens;
        this.topK = builder.topK;
        this.topP = builder.topP;
        this.responseFormat = builder.responseFormat;
        this.apiMetadata = AiGeminiRestApi.ApiMetadata.builder().modelId(builder.modelId).key(builder.key).build();
        try {
            String baseUrl = builder.baseUrl.orElse("https://generativelanguage.googleapis.com");
            QuarkusRestClientBuilder restApiBuilder = QuarkusRestClientBuilder.newBuilder().baseUri(new URI(baseUrl)).connectTimeout(builder.timeout.toSeconds(), TimeUnit.SECONDS).readTimeout(builder.timeout.toSeconds(), TimeUnit.SECONDS);
            if (builder.logRequests.booleanValue() || builder.logResponses.booleanValue()) {
                restApiBuilder.loggingScope(LoggingScope.REQUEST_RESPONSE);
                restApiBuilder.clientLogger((ClientLogger)new AiGeminiRestApi.AiClientLogger(builder.logRequests, builder.logResponses));
            }
            this.restApi = (AiGeminiRestApi)restApiBuilder.build(AiGeminiRestApi.class);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<Capability> supportedCapabilities() {
        HashSet<Capability> capabilities = new HashSet<Capability>();
        if (this.responseFormat != null && ResponseFormatType.JSON.equals((Object)this.responseFormat.type())) {
            capabilities.add(Capability.RESPONSE_FORMAT_JSON_SCHEMA);
        } else if (this.responseFormat == null) {
            capabilities.add(Capability.RESPONSE_FORMAT_JSON_SCHEMA);
        }
        return capabilities;
    }

    public ChatResponse chat(ChatRequest chatRequest) {
        ChatRequestParameters requestParameters = chatRequest.parameters();
        ResponseFormat effectiveResponseFormat = (ResponseFormat)Utils.getOrDefault((Object)requestParameters.responseFormat(), (Object)this.responseFormat);
        GenerationConfig generationConfig = GenerationConfig.builder().maxOutputTokens((Integer)Utils.getOrDefault((Object)requestParameters.maxOutputTokens(), (Object)this.maxOutputTokens)).responseMimeType(this.computeMimeType(effectiveResponseFormat)).responseSchema(effectiveResponseFormat != null ? SchemaMapper.fromJsonSchemaToSchema((JsonSchema)effectiveResponseFormat.jsonSchema()) : null).stopSequences(requestParameters.stopSequences()).temperature((Double)Utils.getOrDefault((Object)requestParameters.temperature(), (Object)this.temperature)).topK((Integer)Utils.getOrDefault((Object)requestParameters.topK(), (Object)this.topK)).topP((Double)Utils.getOrDefault((Object)requestParameters.topP(), (Object)this.topP)).build();
        GenerateContentRequest request = ContentMapper.map((List)chatRequest.messages(), (List)chatRequest.toolSpecifications(), (GenerationConfig)generationConfig);
        GenerateContentResponse response = this.restApi.generateContent(request, this.apiMetadata);
        String text = GenerateContentResponseHandler.getText((GenerateContentResponse)response);
        List toolExecutionRequests = GenerateContentResponseHandler.getToolExecutionRequests((GenerateContentResponse)response);
        AiMessage aiMessage = toolExecutionRequests.isEmpty() ? AiMessage.aiMessage((String)text) : AiMessage.aiMessage((String)text, (List)toolExecutionRequests);
        return ChatResponse.builder().aiMessage(aiMessage).tokenUsage(GenerateContentResponseHandler.getTokenUsage((GenerateContentResponse.UsageMetadata)response.usageMetadata())).finishReason(FinishReasonMapper.map((GenerateContentResponse.FinishReason)GenerateContentResponseHandler.getFinishReason((GenerateContentResponse)response))).build();
    }

    private String computeMimeType(ResponseFormat responseFormat) {
        if (responseFormat == null || ResponseFormatType.TEXT.equals((Object)responseFormat.type())) {
            return "text/plain";
        }
        if (ResponseFormatType.JSON.equals((Object)responseFormat.type()) && responseFormat.jsonSchema() != null && responseFormat.jsonSchema().rootElement() != null && responseFormat.jsonSchema().rootElement() instanceof JsonEnumSchema) {
            return "text/x.enum";
        }
        return "application/json";
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        ChatResponse chatResponse = this.chat(ChatRequest.builder().messages(messages).toolSpecifications(toolSpecifications).build());
        return Response.from((Object)chatResponse.aiMessage(), (TokenUsage)chatResponse.tokenUsage(), (FinishReason)chatResponse.finishReason());
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        return this.generate(messages, Collections.emptyList());
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, ToolSpecification toolSpecification) {
        return this.generate(messages, toolSpecification != null ? Collections.singletonList(toolSpecification) : Collections.emptyList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Optional<String> baseUrl = Optional.empty();
        private String modelId;
        private String key;
        private Double temperature;
        private Integer maxOutputTokens;
        private Integer topK;
        private Double topP;
        private ResponseFormat responseFormat;
        private Duration timeout = Duration.ofSeconds(10L);
        private Boolean logRequests = false;
        private Boolean logResponses = false;

        public Builder baseUrl(Optional<String> baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder maxOutputTokens(Integer maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
            return this;
        }

        public Builder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public Builder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder logRequests(boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public Builder logResponses(boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public AiGeminiChatLanguageModel build() {
            return new AiGeminiChatLanguageModel(this);
        }
    }
}

