/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.ai.runtime.gemini;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.DisabledChatLanguageModel;
import dev.langchain4j.model.embedding.DisabledEmbeddingModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import io.quarkiverse.langchain4j.ai.runtime.gemini.AiGeminiChatLanguageModel;
import io.quarkiverse.langchain4j.ai.runtime.gemini.AiGeminiEmbeddingModel;
import io.quarkiverse.langchain4j.ai.runtime.gemini.config.ChatModelConfig;
import io.quarkiverse.langchain4j.ai.runtime.gemini.config.LangChain4jAiGeminiConfig;
import io.quarkiverse.langchain4j.ai.runtime.gemini.config.LangChain4jAiGeminiEmbeddingConfig;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkiverse.langchain4j.runtime.OptionalUtil;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.config.ConfigValidationException;
import java.util.Optional;
import java.util.function.Supplier;

@Recorder
public class AiGeminiRecorder {
    private static final String DUMMY_KEY = "dummy";

    public Supplier<EmbeddingModel> embeddingModel(LangChain4jAiGeminiConfig config, String configName) {
        LangChain4jAiGeminiConfig.AiGeminiConfig aiConfig = this.correspondingAiConfig(config, configName);
        if (aiConfig.enableIntegration().booleanValue()) {
            LangChain4jAiGeminiEmbeddingConfig embeddingModelConfig = aiConfig.embeddingModel();
            Optional<String> baseUrl = aiConfig.baseUrl();
            String key = aiConfig.apiKey();
            if (baseUrl.isEmpty() && DUMMY_KEY.equals(key)) {
                throw new ConfigValidationException(AiGeminiRecorder.createConfigProblems("api-key", configName));
            }
            AiGeminiEmbeddingModel.Builder builder = AiGeminiEmbeddingModel.builder().baseUrl(baseUrl).key(key).modelId(embeddingModelConfig.modelId()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{embeddingModelConfig.logRequests(), aiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{embeddingModelConfig.logResponses(), aiConfig.logResponses()}));
            if (embeddingModelConfig.outputDimension().isPresent()) {
                builder.dimension(embeddingModelConfig.outputDimension().get());
            }
            return builder::build;
        }
        return DisabledEmbeddingModel::new;
    }

    public Supplier<ChatLanguageModel> chatModel(LangChain4jAiGeminiConfig config, String configName) {
        LangChain4jAiGeminiConfig.AiGeminiConfig aiConfig = this.correspondingAiConfig(config, configName);
        if (aiConfig.enableIntegration().booleanValue()) {
            ChatModelConfig chatModelConfig = aiConfig.chatModel();
            Optional<String> baseUrl = aiConfig.baseUrl();
            String key = aiConfig.apiKey();
            if (baseUrl.isEmpty() && DUMMY_KEY.equals(key)) {
                throw new ConfigValidationException(AiGeminiRecorder.createConfigProblems("api-key", configName));
            }
            final AiGeminiChatLanguageModel.Builder builder = AiGeminiChatLanguageModel.builder().baseUrl(baseUrl).key(key).modelId(chatModelConfig.modelId()).maxOutputTokens(chatModelConfig.maxOutputTokens()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logRequests(), aiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logResponses(), aiConfig.logResponses()}));
            if (chatModelConfig.temperature().isPresent()) {
                builder.temperature(chatModelConfig.temperature().getAsDouble());
            }
            if (chatModelConfig.topK().isPresent()) {
                builder.topK(chatModelConfig.topK().getAsInt());
            }
            if (chatModelConfig.topP().isPresent()) {
                builder.topP(chatModelConfig.topP().getAsDouble());
            }
            if (chatModelConfig.timeout().isPresent()) {
                builder.timeout(chatModelConfig.timeout().get());
            }
            return new Supplier<ChatLanguageModel>(this){
                final /* synthetic */ AiGeminiRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ChatLanguageModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<ChatLanguageModel>(){

            @Override
            public ChatLanguageModel get() {
                return new DisabledChatLanguageModel();
            }
        };
    }

    private LangChain4jAiGeminiConfig.AiGeminiConfig correspondingAiConfig(LangChain4jAiGeminiConfig runtimeConfig, String configName) {
        return NamedConfigUtil.isDefault((String)configName) ? runtimeConfig.defaultConfig() : runtimeConfig.namedConfig().get(configName);
    }

    private static ConfigValidationException.Problem[] createConfigProblems(String key, String configName) {
        return new ConfigValidationException.Problem[]{AiGeminiRecorder.createConfigProblem(key, configName)};
    }

    private static ConfigValidationException.Problem createConfigProblem(String key, String configName) {
        return new ConfigValidationException.Problem("SRCFG00014: The config property quarkus.langchain4j.ai.gemini%s%s is required but it could not be found in any config source".formatted(NamedConfigUtil.isDefault((String)configName) ? "." : "." + configName + ".", key));
    }
}

