/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.ai.runtime.gemini;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.langchain4j.ai.runtime.gemini.ErrorResponse;
import io.quarkiverse.langchain4j.gemini.common.EmbedContentRequest;
import io.quarkiverse.langchain4j.gemini.common.EmbedContentRequests;
import io.quarkiverse.langchain4j.gemini.common.EmbedContentResponse;
import io.quarkiverse.langchain4j.gemini.common.EmbedContentResponses;
import io.quarkiverse.langchain4j.gemini.common.GenerateContentRequest;
import io.quarkiverse.langchain4j.gemini.common.GenerateContentResponse;
import io.quarkus.rest.client.reactive.ClientExceptionMapper;
import io.quarkus.rest.client.reactive.jackson.ClientObjectMapper;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.ClientWebApplicationException;
import org.jboss.resteasy.reactive.RestPath;
import org.jboss.resteasy.reactive.RestQuery;
import org.jboss.resteasy.reactive.client.api.ClientLogger;

@Path(value="v1beta/models/")
public interface AiGeminiRestApi {
    @Path(value="{modelId}:batchEmbedContents")
    @POST
    public EmbedContentResponses batchEmbedContents(EmbedContentRequests var1, @BeanParam ApiMetadata var2);

    @Path(value="{modelId}:embedContent")
    @POST
    public EmbedContentResponse embedContent(EmbedContentRequest var1, @BeanParam ApiMetadata var2);

    @Path(value="{modelId}:generateContent")
    @POST
    public GenerateContentResponse generateContent(GenerateContentRequest var1, @BeanParam ApiMetadata var2);

    @ClientExceptionMapper
    public static ClientWebApplicationException toException(Response response) {
        if (response.getStatus() == 400) {
            ErrorResponse errorResponse = (ErrorResponse)response.readEntity(ErrorResponse.class);
            ErrorResponse.ErrorInfo errorInfo = errorResponse.error();
            return new ClientWebApplicationException(errorInfo.status() + ": " + errorInfo.message());
        }
        return null;
    }

    @ClientObjectMapper
    public static ObjectMapper mapper(ObjectMapper defaultObjectMapper) {
        return defaultObjectMapper.copy().setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static class AiClientLogger
    implements ClientLogger {
        private static final Logger log = Logger.getLogger(AiClientLogger.class);
        private final boolean logRequests;
        private final boolean logResponses;

        public AiClientLogger(boolean logRequests, boolean logResponses) {
            this.logRequests = logRequests;
            this.logResponses = logResponses;
        }

        public void setBodySize(int bodySize) {
        }

        public void logRequest(HttpClientRequest request, Buffer body, boolean omitBody) {
            if (!this.logRequests || !log.isInfoEnabled()) {
                return;
            }
            try {
                log.infof("Request:\n- method: %s\n- url: %s\n- headers: %s\n- body: %s", new Object[]{request.getMethod(), request.absoluteURI(), request.headers(), this.bodyToString(body)});
            }
            catch (Exception e) {
                log.warn((Object)"Failed to log request", (Throwable)e);
            }
        }

        public void logResponse(final HttpClientResponse response, boolean redirect) {
            if (!this.logResponses || !log.isInfoEnabled()) {
                return;
            }
            response.bodyHandler((Handler)new Handler<Buffer>(this){
                final /* synthetic */ AiClientLogger this$0;
                {
                    this.this$0 = this$0;
                }

                public void handle(Buffer body) {
                    try {
                        log.infof("Response:\n- status code: %s\n- headers: %s\n- body: %s", (Object)response.statusCode(), (Object)response.headers(), (Object)this.this$0.bodyToString(body));
                    }
                    catch (Exception e) {
                        log.warn((Object)"Failed to log response", (Throwable)e);
                    }
                }
            });
        }

        private String bodyToString(Buffer body) {
            if (body == null) {
                return "";
            }
            return body.toString();
        }
    }

    public static class ApiMetadata {
        @RestQuery
        public final String key;
        @RestPath
        public final String modelId;

        private ApiMetadata(Builder builder) {
            this.key = builder.key;
            this.modelId = builder.modelId;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String key;
            private String modelId;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder modelId(String modelId) {
                this.modelId = modelId;
                return this;
            }

            public ApiMetadata build() {
                return new ApiMetadata(this);
            }
        }
    }
}

