/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.azure.openai.deployment;

import io.quarkiverse.langchain4j.ModelName;
import io.quarkiverse.langchain4j.azure.openai.deployment.LangChain4jAzureOpenAiBuildConfig;
import io.quarkiverse.langchain4j.azure.openai.runtime.AzureOpenAiRecorder;
import io.quarkiverse.langchain4j.azure.openai.runtime.config.LangChain4jAzureOpenAiConfig;
import io.quarkiverse.langchain4j.deployment.DotNames;
import io.quarkiverse.langchain4j.deployment.LangChain4jDotNames;
import io.quarkiverse.langchain4j.deployment.items.ChatModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.EmbeddingModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.ImageModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.ModerationModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedChatModelProviderBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedEmbeddingModelCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedImageModelProviderBuildItem;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.runtime.ShutdownContext;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.List;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class AzureOpenAiProcessor {
    private static final String FEATURE = "langchain4j-azure-openai";
    private static final String PROVIDER = "azure-openai";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public void providerCandidates(BuildProducer<ChatModelProviderCandidateBuildItem> chatProducer, BuildProducer<EmbeddingModelProviderCandidateBuildItem> embeddingProducer, BuildProducer<ModerationModelProviderCandidateBuildItem> moderationProducer, BuildProducer<ImageModelProviderCandidateBuildItem> imageProducer, LangChain4jAzureOpenAiBuildConfig config) {
        if (config.chatModel().enabled().isEmpty() || config.chatModel().enabled().get().booleanValue()) {
            chatProducer.produce((BuildItem)new ChatModelProviderCandidateBuildItem(PROVIDER));
        }
        if (config.embeddingModel().enabled().isEmpty() || config.embeddingModel().enabled().get().booleanValue()) {
            embeddingProducer.produce((BuildItem)new EmbeddingModelProviderCandidateBuildItem(PROVIDER));
        }
        if (config.imageModel().enabled().isEmpty() || config.imageModel().enabled().get().booleanValue()) {
            imageProducer.produce((BuildItem)new ImageModelProviderCandidateBuildItem(PROVIDER));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void generateBeans(AzureOpenAiRecorder recorder, List<SelectedChatModelProviderBuildItem> selectedChatItem, List<SelectedEmbeddingModelCandidateBuildItem> selectedEmbedding, List<SelectedImageModelProviderBuildItem> selectedImage, LangChain4jAzureOpenAiConfig config, BuildProducer<SyntheticBeanBuildItem> beanProducer) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator builder;
        String configName;
        for (SelectedChatModelProviderBuildItem selectedChatModelProviderBuildItem : selectedChatItem) {
            if (!PROVIDER.equals(selectedChatModelProviderBuildItem.getProvider())) continue;
            configName = selectedChatModelProviderBuildItem.getConfigName();
            Function chatModel = recorder.chatModel(config, configName);
            SyntheticBeanBuildItem.ExtendedBeanConfigurator chatBuilder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)LangChain4jDotNames.CHAT_MODEL).setRuntimeInit().defaultBean()).scope(ApplicationScoped.class)).addInjectionPoint((Type)ParameterizedType.create((DotName)DotNames.CDI_INSTANCE, (Type[])new Type[]{ClassType.create((DotName)DotNames.CHAT_MODEL_LISTENER)}, null), new AnnotationInstance[0])).addInjectionPoint((Type)ParameterizedType.create((DotName)DotNames.CDI_INSTANCE, (Type[])new Type[]{ClassType.create((DotName)DotNames.MODEL_AUTH_PROVIDER)}, null), new AnnotationInstance[0])).createWith(chatModel);
            this.addQualifierIfNecessary(chatBuilder, configName);
            beanProducer.produce((BuildItem)chatBuilder.done());
            SyntheticBeanBuildItem.ExtendedBeanConfigurator tokenCountBuilder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)LangChain4jDotNames.TOKEN_COUNT_ESTIMATOR).setRuntimeInit().defaultBean()).scope(ApplicationScoped.class)).addInjectionPoint((Type)ParameterizedType.create((DotName)DotNames.CDI_INSTANCE, (Type[])new Type[]{ClassType.create((DotName)DotNames.CHAT_MODEL_LISTENER)}, null), new AnnotationInstance[0])).addInjectionPoint((Type)ParameterizedType.create((DotName)DotNames.CDI_INSTANCE, (Type[])new Type[]{ClassType.create((DotName)DotNames.MODEL_AUTH_PROVIDER)}, null), new AnnotationInstance[0])).createWith(chatModel);
            this.addQualifierIfNecessary(tokenCountBuilder, configName);
            beanProducer.produce((BuildItem)tokenCountBuilder.done());
            Function streamingChatModel = recorder.streamingChatModel(config, configName);
            SyntheticBeanBuildItem.ExtendedBeanConfigurator streamingBuilder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)LangChain4jDotNames.STREAMING_CHAT_MODEL).setRuntimeInit().defaultBean()).scope(ApplicationScoped.class)).addInjectionPoint((Type)ParameterizedType.create((DotName)DotNames.CDI_INSTANCE, (Type[])new Type[]{ClassType.create((DotName)DotNames.CHAT_MODEL_LISTENER)}, null), new AnnotationInstance[0])).addInjectionPoint((Type)ParameterizedType.create((DotName)DotNames.CDI_INSTANCE, (Type[])new Type[]{ClassType.create((DotName)DotNames.MODEL_AUTH_PROVIDER)}, null), new AnnotationInstance[0])).createWith(streamingChatModel);
            this.addQualifierIfNecessary(streamingBuilder, configName);
            beanProducer.produce((BuildItem)streamingBuilder.done());
        }
        for (SelectedEmbeddingModelCandidateBuildItem selectedEmbeddingModelCandidateBuildItem : selectedEmbedding) {
            if (!PROVIDER.equals(selectedEmbeddingModelCandidateBuildItem.getProvider())) continue;
            configName = selectedEmbeddingModelCandidateBuildItem.getConfigName();
            Function embeddingModel = recorder.embeddingModel(config, configName);
            builder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)LangChain4jDotNames.EMBEDDING_MODEL).setRuntimeInit().unremovable()).defaultBean()).scope(ApplicationScoped.class)).addInjectionPoint((Type)ParameterizedType.create((DotName)DotNames.CDI_INSTANCE, (Type[])new Type[]{ClassType.create((DotName)DotNames.MODEL_AUTH_PROVIDER)}, null), new AnnotationInstance[0])).createWith(embeddingModel);
            this.addQualifierIfNecessary(builder, configName);
            beanProducer.produce((BuildItem)builder.done());
        }
        for (SelectedImageModelProviderBuildItem selectedImageModelProviderBuildItem : selectedImage) {
            if (!PROVIDER.equals(selectedImageModelProviderBuildItem.getProvider())) continue;
            configName = selectedImageModelProviderBuildItem.getConfigName();
            Function imageModel = recorder.imageModel(config, configName);
            builder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)LangChain4jDotNames.IMAGE_MODEL).setRuntimeInit().defaultBean()).scope(ApplicationScoped.class)).addInjectionPoint((Type)ParameterizedType.create((DotName)DotNames.CDI_INSTANCE, (Type[])new Type[]{ClassType.create((DotName)DotNames.MODEL_AUTH_PROVIDER)}, null), new AnnotationInstance[0])).createWith(imageModel);
            this.addQualifierIfNecessary(builder, configName);
            beanProducer.produce((BuildItem)builder.done());
        }
    }

    private void addQualifierIfNecessary(SyntheticBeanBuildItem.ExtendedBeanConfigurator builder, String configName) {
        if (!NamedConfigUtil.isDefault((String)configName)) {
            builder.addQualifier(AnnotationInstance.builder(ModelName.class).add("value", configName).build());
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void cleanUp(AzureOpenAiRecorder recorder, ShutdownContextBuildItem shutdown) {
        recorder.cleanUp((ShutdownContext)shutdown);
    }
}

