/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.azure.openai.runtime.config;

import io.quarkiverse.langchain4j.azure.openai.runtime.config.ChatModelConfig;
import io.quarkiverse.langchain4j.azure.openai.runtime.config.EmbeddingModelConfig;
import io.quarkiverse.langchain4j.azure.openai.runtime.config.ImageModelConfig;
import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithDefaults;
import io.smallrye.config.WithParentName;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

@ConfigRoot(phase=ConfigPhase.RUN_TIME)
@ConfigMapping(prefix="quarkus.langchain4j.azure-openai")
public interface LangChain4jAzureOpenAiConfig {
    @WithParentName
    public AzureAiConfig defaultConfig();

    @ConfigDocSection
    @ConfigDocMapKey(value="model-name")
    @WithParentName
    @WithDefaults
    public Map<String, AzureAiConfig> namedConfig();

    @ConfigGroup
    public static interface AzureAiConfig {
        public Optional<String> resourceName();

        @WithDefault(value="openai.azure.com")
        public Optional<String> domainName();

        public Optional<String> deploymentName();

        public Optional<String> endpoint();

        public Optional<String> adToken();

        @WithDefault(value="2023-05-15")
        public String apiVersion();

        public Optional<String> apiKey();

        @ConfigDocDefault(value="10s")
        @WithDefault(value="${quarkus.langchain4j.timeout}")
        public Optional<Duration> timeout();

        @WithDefault(value="1")
        public Integer maxRetries();

        @ConfigDocDefault(value="false")
        @WithDefault(value="${quarkus.langchain4j.log-requests}")
        public Optional<Boolean> logRequests();

        @ConfigDocDefault(value="false")
        @WithDefault(value="${quarkus.langchain4j.log-responses}")
        public Optional<Boolean> logResponses();

        @WithDefault(value="true")
        public Boolean enableIntegration();

        public ChatModelConfig chatModel();

        public EmbeddingModelConfig embeddingModel();

        public ImageModelConfig imageModel();

        default public Optional<String> domainNameFor(EndpointType type) {
            Optional<String> deepDomainName = switch (type.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> this.chatModel().domainName();
                case 1 -> this.embeddingModel().domainName();
                case 2 -> this.imageModel().domainName();
            };
            return deepDomainName.filter(v -> !"<dummy>".equals(v)).or(new Supplier<Optional<String>>(){

                @Override
                public Optional<String> get() {
                    return this.domainName();
                }
            });
        }

        default public Optional<String> endPointFor(EndpointType type) {
            Optional<String> deepEndpoint = switch (type.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> this.chatModel().endpoint();
                case 1 -> this.embeddingModel().endpoint();
                case 2 -> this.imageModel().endpoint();
            };
            return deepEndpoint.filter(v -> !"<dummy>".equals(v)).or(new Supplier<Optional<String>>(){

                @Override
                public Optional<String> get() {
                    return this.endpoint();
                }
            });
        }

        default public Optional<String> resourceNameFor(EndpointType type) {
            Optional<String> deepResourceName = switch (type.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> this.chatModel().resourceName();
                case 1 -> this.embeddingModel().resourceName();
                case 2 -> this.imageModel().resourceName();
            };
            return deepResourceName.filter(v -> !"<dummy>".equals(v)).or(new Supplier<Optional<String>>(){

                @Override
                public Optional<String> get() {
                    return this.resourceName();
                }
            });
        }

        default public Optional<String> deploymentNameFor(EndpointType type) {
            Optional<String> deepDeploymentName = switch (type.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> this.chatModel().deploymentName();
                case 1 -> this.embeddingModel().deploymentName();
                case 2 -> this.imageModel().deploymentName();
            };
            return deepDeploymentName.filter(v -> !"<dummy>".equals(v)).or(new Supplier<Optional<String>>(){

                @Override
                public Optional<String> get() {
                    return this.deploymentName();
                }
            });
        }

        public static enum EndpointType {
            CHAT,
            EMBEDDING,
            IMAGE;

        }
    }
}

