/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.azure.openai;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.TokenCountEstimator;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.openai.internal.OpenAiClient;
import dev.langchain4j.model.openai.internal.embedding.EmbeddingRequest;
import dev.langchain4j.model.openai.internal.embedding.EmbeddingResponse;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import io.quarkiverse.langchain4j.openai.common.QuarkusOpenAiClient;
import java.net.Proxy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class AzureOpenAiEmbeddingModel
implements EmbeddingModel {
    private static final int BATCH_SIZE = 16;
    private final OpenAiClient client;
    private final Integer maxRetries;
    private final TokenCountEstimator tokenizer;

    public AzureOpenAiEmbeddingModel(String endpoint, String apiVersion, String apiKey, String adToken, TokenCountEstimator tokenizer, Duration timeout, Integer maxRetries, Proxy proxy, Boolean logRequests, Boolean logResponses, String configName) {
        timeout = (Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L));
        if (maxRetries < 1) {
            throw new IllegalArgumentException("max-retries must be at least 1");
        }
        this.client = ((QuarkusOpenAiClient.Builder)((QuarkusOpenAiClient.Builder)((QuarkusOpenAiClient.Builder)((QuarkusOpenAiClient.Builder)((QuarkusOpenAiClient.Builder)QuarkusOpenAiClient.builder().baseUrl(ValidationUtils.ensureNotBlank((String)endpoint, (String)"endpoint"))).apiVersion(apiVersion).callTimeout(timeout).connectTimeout(timeout)).readTimeout(timeout)).writeTimeout(timeout).proxy(proxy).logRequests(logRequests)).logResponses(logResponses)).userAgent("langchain4j-quarkus-azure-openai").azureAdToken(adToken).azureApiKey(apiKey).configName(configName).build();
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
        this.tokenizer = tokenizer;
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        List<String> texts = textSegments.stream().map(TextSegment::text).collect(Collectors.toList());
        return this.embedTexts(texts);
    }

    private Response<List<Embedding>> embedTexts(List<String> texts) {
        ArrayList embeddings = new ArrayList();
        int inputTokenCount = 0;
        for (int i = 0; i < texts.size(); i += 16) {
            List<String> batch = texts.subList(i, Math.min(i + 16, texts.size()));
            EmbeddingRequest request = EmbeddingRequest.builder().input(batch).build();
            EmbeddingResponse response = (EmbeddingResponse)RetryUtils.withRetry(() -> (EmbeddingResponse)this.client.embedding(request).execute(), (int)this.maxRetries);
            embeddings.addAll(response.data().stream().map(openAiEmbedding -> Embedding.from((List)openAiEmbedding.embedding())).collect(Collectors.toList()));
            inputTokenCount += response.usage().promptTokens().intValue();
        }
        return Response.from(embeddings, (TokenUsage)new TokenUsage(Integer.valueOf(inputTokenCount)));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String endpoint;
        private String apiVersion;
        private String apiKey;
        private TokenCountEstimator tokenizer;
        private Duration timeout;
        private Integer maxRetries;
        private Proxy proxy;
        private Boolean logRequests;
        private Boolean logResponses;
        private String adToken;
        private String configName;

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder adToken(String adToken) {
            this.adToken = adToken;
            return this;
        }

        public Builder tokenizer(TokenCountEstimator tokenizer) {
            this.tokenizer = tokenizer;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public Builder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public Builder configName(String configName) {
            this.configName = configName;
            return this;
        }

        public AzureOpenAiEmbeddingModel build() {
            return new AzureOpenAiEmbeddingModel(this.endpoint, this.apiVersion, this.apiKey, this.adToken, this.tokenizer, this.timeout, this.maxRetries, this.proxy, this.logRequests, this.logResponses, this.configName);
        }
    }
}

