/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.chroma;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingStore;
import io.quarkiverse.langchain4j.chroma.runtime.AddEmbeddingsRequest;
import io.quarkiverse.langchain4j.chroma.runtime.ChromaCollectionsRestApi;
import io.quarkiverse.langchain4j.chroma.runtime.Collection;
import io.quarkiverse.langchain4j.chroma.runtime.CreateCollectionRequest;
import io.quarkiverse.langchain4j.chroma.runtime.QueryRequest;
import io.quarkiverse.langchain4j.chroma.runtime.QueryResponse;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.rest.client.reactive.QuarkusRestClientBuilder;
import jakarta.ws.rs.WebApplicationException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ChromaEmbeddingStore
implements EmbeddingStore<TextSegment> {
    private final ChromaClient chromaClient;
    private final LazyValue<String> collectionId;

    public ChromaEmbeddingStore(String baseUrl, String collectionName, Duration timeout) {
        final String effectiveCollectionName = (String)Utils.getOrDefault((Object)collectionName, (Object)"default");
        this.chromaClient = new ChromaClient(baseUrl, (Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(5L)));
        this.collectionId = new LazyValue((Supplier)new Supplier<String>(){

            @Override
            public String get() {
                Collection collection = ChromaEmbeddingStore.this.chromaClient.collection(effectiveCollectionName);
                if (collection == null) {
                    Collection createdCollection = ChromaEmbeddingStore.this.chromaClient.createCollection(new CreateCollectionRequest(effectiveCollectionName));
                    return createdCollection.getId();
                }
                return collection.getId();
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    public String add(Embedding embedding) {
        String id = Utils.randomUUID();
        this.add(id, embedding);
        return id;
    }

    public void add(String id, Embedding embedding) {
        this.addInternal(id, embedding, null);
    }

    public String add(Embedding embedding, TextSegment textSegment) {
        String id = Utils.randomUUID();
        this.addInternal(id, embedding, textSegment);
        return id;
    }

    public List<String> addAll(List<Embedding> embeddings) {
        List<String> ids = embeddings.stream().map(embedding -> Utils.randomUUID()).collect(Collectors.toList());
        this.addAllInternal(ids, embeddings, null);
        return ids;
    }

    public List<String> addAll(List<Embedding> embeddings, List<TextSegment> textSegments) {
        List<String> ids = embeddings.stream().map(embedding -> Utils.randomUUID()).collect(Collectors.toList());
        this.addAllInternal(ids, embeddings, textSegments);
        return ids;
    }

    private void addInternal(String id, Embedding embedding, TextSegment textSegment) {
        this.addAllInternal(Collections.singletonList(id), Collections.singletonList(embedding), textSegment == null ? null : Collections.singletonList(textSegment));
    }

    private void addAllInternal(List<String> ids, List<Embedding> embeddings, List<TextSegment> textSegments) {
        AddEmbeddingsRequest addEmbeddingsRequest = AddEmbeddingsRequest.builder().embeddings(embeddings.stream().map(Embedding::vector).collect(Collectors.toList())).ids(ids).metadatas(textSegments == null ? null : textSegments.stream().map(TextSegment::metadata).map(Metadata::asMap).collect(Collectors.toList())).documents(textSegments == null ? null : textSegments.stream().map(TextSegment::text).collect(Collectors.toList())).build();
        this.chromaClient.addEmbeddings((String)this.collectionId.get(), addEmbeddingsRequest);
    }

    public List<EmbeddingMatch<TextSegment>> findRelevant(Embedding referenceEmbedding, int maxResults, double minScore) {
        QueryRequest queryRequest = new QueryRequest(referenceEmbedding.vectorAsList(), maxResults);
        QueryResponse queryResponse = this.chromaClient.queryCollection((String)this.collectionId.get(), queryRequest);
        List<EmbeddingMatch<TextSegment>> matches = ChromaEmbeddingStore.toEmbeddingMatches(queryResponse);
        return matches.stream().filter(match -> match.score() >= minScore).collect(Collectors.toList());
    }

    private static List<EmbeddingMatch<TextSegment>> toEmbeddingMatches(QueryResponse queryResponse) {
        ArrayList<EmbeddingMatch<TextSegment>> embeddingMatches = new ArrayList<EmbeddingMatch<TextSegment>>();
        for (int i = 0; i < queryResponse.getIds().get(0).size(); ++i) {
            double score = ChromaEmbeddingStore.distanceToScore(queryResponse.getDistances().get(0).get(i));
            String embeddingId = queryResponse.getIds().get(0).get(i);
            Embedding embedding = Embedding.from(queryResponse.getEmbeddings().get(0).get(i));
            TextSegment textSegment = ChromaEmbeddingStore.toTextSegment(queryResponse, i);
            embeddingMatches.add((EmbeddingMatch<TextSegment>)new EmbeddingMatch(Double.valueOf(score), embeddingId, embedding, (Object)textSegment));
        }
        return embeddingMatches;
    }

    private static double distanceToScore(double distance) {
        return 1.0 - distance / 2.0;
    }

    private static TextSegment toTextSegment(QueryResponse queryResponse, int i) {
        String text = queryResponse.getDocuments().get(0).get(i);
        Map<String, String> metadata = queryResponse.getMetadatas().get(0).get(i);
        return text == null ? null : TextSegment.from((String)text, (Metadata)(metadata == null ? new Metadata() : new Metadata(metadata)));
    }

    private static class ChromaClient {
        private final ChromaCollectionsRestApi chromaApi;

        ChromaClient(String baseUrl, Duration timeout) {
            try {
                this.chromaApi = (ChromaCollectionsRestApi)QuarkusRestClientBuilder.newBuilder().baseUri(new URI(baseUrl)).connectTimeout(timeout.toSeconds(), TimeUnit.SECONDS).readTimeout(timeout.toSeconds(), TimeUnit.SECONDS).build(ChromaCollectionsRestApi.class);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        Collection createCollection(CreateCollectionRequest createCollectionRequest) {
            return this.chromaApi.createCollection(createCollectionRequest);
        }

        Collection collection(String collectionName) {
            try {
                return this.chromaApi.collection(collectionName);
            }
            catch (WebApplicationException e) {
                return null;
            }
        }

        boolean addEmbeddings(String collectionId, AddEmbeddingsRequest addEmbeddingsRequest) {
            return this.chromaApi.addEmbeddings(collectionId, addEmbeddingsRequest);
        }

        QueryResponse queryCollection(String collectionId, QueryRequest queryRequest) {
            return this.chromaApi.queryCollection(collectionId, queryRequest);
        }
    }

    public static class Builder {
        private String baseUrl;
        private String collectionName;
        private Duration timeout;

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public ChromaEmbeddingStore build() {
            return new ChromaEmbeddingStore(this.baseUrl, this.collectionName, this.timeout);
        }
    }
}

