/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.deployment;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.rag.RetrievalAugmentor;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.inmemory.InMemoryEmbeddingStore;
import io.quarkiverse.langchain4j.deployment.EmbeddingStoreBuildItem;
import io.quarkiverse.langchain4j.deployment.items.AutoCreateEmbeddingModelBuildItem;
import io.quarkiverse.langchain4j.deployment.items.InMemoryEmbeddingStoreBuildItem;
import io.quarkiverse.langchain4j.easyrag.EasyRagManualIngestion;
import io.quarkiverse.langchain4j.easyrag.runtime.EasyRagRecorder;
import io.quarkiverse.langchain4j.easyrag.runtime.EasyRetrievalAugmentor;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.List;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class EasyRagProcessor {
    public static final DotName IN_MEMORY_EMBEDDING_STORE = DotName.createSimple(InMemoryEmbeddingStore.class);
    static final String FEATURE = "langchain4j-easy-rag";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public void registerManualIngestionTrigger(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(EasyRagManualIngestion.class).build());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void ingest(EasyRagRecorder recorder, BeanContainerBuildItem beanContainer) {
        recorder.ingest(beanContainer.getValue());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void createInMemoryEmbeddingStoreIfNoOtherExists(BuildProducer<SyntheticBeanBuildItem> beanProducer, List<EmbeddingStoreBuildItem> embeddingStores, EasyRagRecorder recorder, BuildProducer<InMemoryEmbeddingStoreBuildItem> inMemoryEmbeddingStoreBuildItemBuildProducer) {
        if (embeddingStores.isEmpty()) {
            beanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)IN_MEMORY_EMBEDDING_STORE).types(new Type[]{ClassType.create(EmbeddingStore.class), ClassType.create(InMemoryEmbeddingStore.class), ParameterizedType.create(EmbeddingStore.class, (Type[])new Type[]{ClassType.create(TextSegment.class)}), ParameterizedType.create(InMemoryEmbeddingStore.class, (Type[])new Type[]{ClassType.create(TextSegment.class)})})).defaultBean()).setRuntimeInit().defaultBean()).unremovable()).scope(ApplicationScoped.class)).supplier(recorder.inMemoryEmbeddingStoreSupplier()).done());
            inMemoryEmbeddingStoreBuildItemBuildProducer.produce((BuildItem)new InMemoryEmbeddingStoreBuildItem());
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void createEasyRetrievalAugmentorIfNoOtherIsFound(BeanDiscoveryFinishedBuildItem beans, BuildProducer<SyntheticBeanBuildItem> beanProducer, BuildProducer<AutoCreateEmbeddingModelBuildItem> autoCreateEmbeddingModelBuildItemBuildProducer, EasyRagRecorder recorder) {
        ClassType retrievalAugmentor = ClassType.create(RetrievalAugmentor.class);
        ParameterizedType retrievalAugmentorSupplier = ParameterizedType.create(Supplier.class, (Type[])new Type[]{retrievalAugmentor});
        for (BeanInfo bean : beans.getBeans()) {
            if (!bean.getTypes().contains(retrievalAugmentor) && !bean.getTypes().contains(retrievalAugmentorSupplier)) continue;
            return;
        }
        autoCreateEmbeddingModelBuildItemBuildProducer.produce((BuildItem)new AutoCreateEmbeddingModelBuildItem());
        beanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)DotName.createSimple((String)EasyRetrievalAugmentor.class.getName())).types(new Type[]{ClassType.create(RetrievalAugmentor.class)})).defaultBean()).setRuntimeInit().defaultBean()).unremovable()).scope(ApplicationScoped.class)).addInjectionPoint((Type)ClassType.create(EmbeddingStore.class), new AnnotationInstance[0])).addInjectionPoint((Type)ClassType.create(EmbeddingModel.class), new AnnotationInstance[0])).createWith(recorder.easyRetrievalAugmentorFunction()).done());
    }
}

