/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.gemini.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.PdfFileContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.CustomMimeTypesFileTypeDetector;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElementHelper;
import io.quarkiverse.langchain4j.QuarkusJsonCodecFactory;
import io.quarkiverse.langchain4j.gemini.common.Blob;
import io.quarkiverse.langchain4j.gemini.common.Content;
import io.quarkiverse.langchain4j.gemini.common.FileData;
import io.quarkiverse.langchain4j.gemini.common.FunctionCall;
import io.quarkiverse.langchain4j.gemini.common.FunctionDeclaration;
import io.quarkiverse.langchain4j.gemini.common.FunctionResponse;
import io.quarkiverse.langchain4j.gemini.common.GenerateContentRequest;
import io.quarkiverse.langchain4j.gemini.common.GenerationConfig;
import io.quarkiverse.langchain4j.gemini.common.RoleMapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ContentMapper {
    private static final CustomMimeTypesFileTypeDetector mimeTypeDetector = new CustomMimeTypesFileTypeDetector();

    private ContentMapper() {
    }

    public static GenerateContentRequest map(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, GenerationConfig generationConfig) {
        ArrayList<String> systemPrompts = new ArrayList<String>();
        ArrayList<Content> contents = new ArrayList<Content>(messages.size());
        HashMap<String, Content> functionCalls = new HashMap<String, Content>();
        HashMap<String, Content> functionResponses = new HashMap<String, Content>();
        for (ChatMessage chatMessage : messages) {
            if (chatMessage instanceof SystemMessage) {
                SystemMessage sm = (SystemMessage)chatMessage;
                systemPrompts.add(sm.text());
                continue;
            }
            String role = RoleMapper.map(chatMessage.type());
            if (chatMessage instanceof UserMessage) {
                UserMessage um = (UserMessage)chatMessage;
                ArrayList parts = new ArrayList(um.contents().size());
                for (dev.langchain4j.data.message.Content userMessageContent : um.contents()) {
                    if (userMessageContent instanceof TextContent) {
                        TextContent tc = (TextContent)userMessageContent;
                        parts.add(Content.Part.ofText(tc.text()));
                        continue;
                    }
                    if (userMessageContent instanceof PdfFileContent) {
                        PdfFileContent fc = (PdfFileContent)userMessageContent;
                        URI uri = fc.pdfFile().url();
                        if (uri != null) {
                            parts.add(Content.Part.ofFileData(new FileData(mimeTypeDetector.probeContentType(uri), uri.toString())));
                            continue;
                        }
                        parts.add(Content.Part.ofInlineData(new Blob("application/pdf", fc.pdfFile().base64Data())));
                        continue;
                    }
                    throw new IllegalArgumentException("The Gemini integration currently only supports text content");
                }
                contents.add(new Content(role, parts));
                continue;
            }
            if (chatMessage instanceof AiMessage) {
                AiMessage am = (AiMessage)chatMessage;
                try {
                    if (am.hasToolExecutionRequests()) {
                        for (ToolExecutionRequest toolExecutionRequest : am.toolExecutionRequests()) {
                            String argumentsStr = toolExecutionRequest.arguments();
                            String name = toolExecutionRequest.name();
                            Map arguments = (Map)QuarkusJsonCodecFactory.ObjectMapperHolder.MAPPER.readValue(argumentsStr, Map.class);
                            FunctionCall functionCall = new FunctionCall(name, arguments);
                            Content.Part part = Content.Part.ofFunctionCall(functionCall);
                            functionCalls.put(name, new Content(role, List.of(part)));
                        }
                        continue;
                    }
                    contents.add(new Content(role, List.of(Content.Part.ofText(am.text()))));
                    continue;
                }
                catch (JsonProcessingException e) {
                    throw new IllegalStateException("Unable to perform conversion of tool response", e);
                }
            }
            if (chatMessage instanceof ToolExecutionResultMessage) {
                ToolExecutionResultMessage toolExecResult = (ToolExecutionResultMessage)chatMessage;
                String toolName = toolExecResult.toolName();
                String content = toolExecResult.text();
                FunctionResponse functionResponse = new FunctionResponse(toolName, new FunctionResponse.Response(toolName, content));
                Content.Part part = Content.Part.ofFunctionResponse(functionResponse);
                functionResponses.put(toolName, new Content(role, List.of(part)));
                continue;
            }
            throw new IllegalArgumentException("The Gemini integration currently does not support " + String.valueOf(chatMessage.type()) + " messages");
        }
        for (Map.Entry entry : functionCalls.entrySet()) {
            contents.add((Content)entry.getValue());
            if (!functionResponses.containsKey(entry.getKey())) continue;
            contents.add((Content)functionResponses.get(entry.getKey()));
        }
        return new GenerateContentRequest(contents, !systemPrompts.isEmpty() ? GenerateContentRequest.SystemInstruction.ofContent(systemPrompts) : null, ContentMapper.toTools(toolSpecifications), generationConfig);
    }

    static List<GenerateContentRequest.Tool> toTools(Collection<ToolSpecification> toolSpecifications) {
        if (toolSpecifications == null) {
            return null;
        }
        if (toolSpecifications.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FunctionDeclaration> functionDeclarations = new ArrayList<FunctionDeclaration>(toolSpecifications.size());
        for (ToolSpecification toolSpecification : toolSpecifications) {
            functionDeclarations.add(ContentMapper.toFunctionDeclaration(toolSpecification));
        }
        return List.of(new GenerateContentRequest.Tool(functionDeclarations));
    }

    private static FunctionDeclaration toFunctionDeclaration(ToolSpecification toolSpecification) {
        FunctionDeclaration.Parameters functionParameters = ContentMapper.toFunctionParameters(toolSpecification.parameters());
        return new FunctionDeclaration(toolSpecification.name(), toolSpecification.description(), functionParameters);
    }

    private static FunctionDeclaration.Parameters toFunctionParameters(JsonObjectSchema parameters) {
        if (parameters == null) {
            return FunctionDeclaration.Parameters.empty();
        }
        return FunctionDeclaration.Parameters.objectType(JsonSchemaElementHelper.toMap((Map)parameters.properties()), parameters.required());
    }
}

