/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.gemini.common;

import com.google.auth.oauth2.GoogleCredentials;
import io.quarkiverse.langchain4j.auth.ModelAuthProvider;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.URI;
import java.util.concurrent.Executor;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestFilter;

public class ModelAuthProviderFilter
implements ResteasyReactiveClientRequestFilter {
    private final ModelAuthProvider authorizer;
    private final Vertx vertx;

    public ModelAuthProviderFilter(String modelId) {
        this.authorizer = ModelAuthProvider.resolve((String)modelId).orElse(new ApplicationDefaultAuthProvider());
        this.vertx = ModelAuthProviderFilter.vertx();
    }

    private static Vertx vertx() {
        Instance vertxInstance = CDI.current().select(Vertx.class, new Annotation[0]);
        return vertxInstance.isResolvable() ? (Vertx)vertxInstance.get() : null;
    }

    public void filter(final ResteasyReactiveClientRequestContext requestContext) {
        if (this.vertx != null) {
            Executor executorService = this.createExecutor();
            requestContext.suspend();
            executorService.execute(new Runnable(){
                final /* synthetic */ ModelAuthProviderFilter this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        this.this$0.setAuthorization(requestContext);
                        requestContext.resume();
                    }
                    catch (Exception e) {
                        requestContext.resume((Throwable)e);
                    }
                }
            });
        } else {
            this.setAuthorization(requestContext);
        }
    }

    private Executor createExecutor() {
        final Context context = this.vertx.getOrCreateContext();
        return new Executor(){
            final /* synthetic */ ModelAuthProviderFilter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void execute(Runnable command) {
                context.runOnContext(v -> command.run());
            }
        };
    }

    private void setAuthorization(ResteasyReactiveClientRequestContext requestContext) {
        String authValue = this.authorizer.getAuthorization((ModelAuthProvider.Input)new AuthInputImpl(requestContext.getMethod(), requestContext.getUri(), (MultivaluedMap<String, Object>)requestContext.getHeaders()));
        if (authValue != null) {
            requestContext.getHeaders().putSingle((Object)"Authorization", (Object)authValue);
        }
    }

    private static class ApplicationDefaultAuthProvider
    implements ModelAuthProvider {
        private ApplicationDefaultAuthProvider() {
        }

        public String getAuthorization(ModelAuthProvider.Input input) {
            try {
                GoogleCredentials credentials = GoogleCredentials.getApplicationDefault();
                credentials.refreshIfExpired();
                return "Bearer " + credentials.getAccessToken().getTokenValue();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static final class AuthInputImpl
    extends Record
    implements ModelAuthProvider.Input {
        private final String method;
        private final URI uri;
        private final MultivaluedMap<String, Object> headers;

        private AuthInputImpl(String method, URI uri, MultivaluedMap<String, Object> headers) {
            this.method = method;
            this.uri = uri;
            this.headers = headers;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{AuthInputImpl.class, "method;uri;headers", "method", "uri", "headers"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{AuthInputImpl.class, "method;uri;headers", "method", "uri", "headers"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{AuthInputImpl.class, "method;uri;headers", "method", "uri", "headers"}, this, o);
        }

        public String method() {
            return this.method;
        }

        public URI uri() {
            return this.uri;
        }

        public MultivaluedMap<String, Object> headers() {
            return this.headers;
        }
    }
}

