/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.gemini.common;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.output.Response;
import io.quarkiverse.langchain4j.gemini.common.Content;
import io.quarkiverse.langchain4j.gemini.common.EmbedContentRequest;
import io.quarkiverse.langchain4j.gemini.common.EmbedContentRequests;
import io.quarkiverse.langchain4j.gemini.common.EmbedContentResponse;
import io.quarkiverse.langchain4j.gemini.common.EmbedContentResponses;
import java.util.List;

public abstract class GeminiEmbeddingModel
implements EmbeddingModel {
    private final String modelId;
    private final Integer dimension;
    private final String taskType;

    public GeminiEmbeddingModel(String modelId, Integer dimension, String taskType) {
        this.modelId = modelId;
        this.dimension = dimension;
        this.taskType = taskType;
    }

    public Response<Embedding> embed(String text) {
        EmbedContentRequest embedContentRequest = this.getEmbedContentRequest(this.modelId, text);
        EmbedContentResponse embedContentResponse = this.embedContent(embedContentRequest);
        return Response.from((Object)Embedding.from((float[])embedContentResponse.embedding().values()));
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        List<EmbedContentRequest> embedContentRequests = textSegments.stream().map(textSegment -> this.getEmbedContentRequest(this.modelId, textSegment.text())).toList();
        EmbedContentResponses embedContentResponses = this.batchEmbedContents(new EmbedContentRequests(embedContentRequests));
        List<Embedding> embeddings = embedContentResponses.embeddings().stream().map(embedding -> Embedding.from((float[])embedding.values())).toList();
        return Response.from(embeddings);
    }

    private EmbedContentRequest getEmbedContentRequest(String model, String text) {
        Content.Part part = Content.Part.ofText(text);
        Content content = Content.ofPart(part);
        EmbedContentRequest.TaskType embedTaskType = null;
        if (this.taskType != null) {
            embedTaskType = EmbedContentRequest.TaskType.valueOf(this.taskType);
        }
        EmbedContentRequest embedContentRequest = new EmbedContentRequest("models/" + model, content, embedTaskType, null, this.dimension);
        return embedContentRequest;
    }

    protected abstract EmbedContentResponse embedContent(EmbedContentRequest var1);

    protected abstract EmbedContentResponses batchEmbedContents(EmbedContentRequests var1);
}

