/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.gemini.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import io.quarkiverse.langchain4j.QuarkusJsonCodecFactory;
import io.quarkiverse.langchain4j.gemini.common.FunctionCall;
import io.quarkiverse.langchain4j.gemini.common.GenerateContentResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

class GeminiStreamingResponseBuilder {
    private final StringBuilder contentBuilder;
    private final List<ToolExecutionRequest> functionCalls;
    private final AtomicReference<String> id = new AtomicReference();
    private final AtomicReference<String> modelName = new AtomicReference();
    private final AtomicReference<TokenUsage> tokenUsage = new AtomicReference();
    private final AtomicReference<FinishReason> finishReason = new AtomicReference();

    public GeminiStreamingResponseBuilder() {
        this.contentBuilder = new StringBuilder();
        this.functionCalls = new ArrayList<ToolExecutionRequest>();
    }

    public Optional<String> append(GenerateContentResponse partialResponse) {
        if (partialResponse == null) {
            return Optional.empty();
        }
        GenerateContentResponse.Candidate firstCandidate = partialResponse.candidates().get(0);
        this.updateId(partialResponse);
        this.updateModelName(partialResponse);
        this.updateFinishReason(firstCandidate);
        this.updateTokenUsage(partialResponse.usageMetadata());
        GenerateContentResponse.Candidate.Content content = firstCandidate.content();
        if (content == null || content.parts() == null) {
            return Optional.empty();
        }
        AiMessage message = GeminiStreamingResponseBuilder.fromGPartsToAiMessage(content.parts());
        this.updateContentAndFunctionCalls(message);
        return Optional.ofNullable(message.text());
    }

    public ChatResponse build() {
        AiMessage aiMessage = this.createAiMessage();
        FinishReason finishReason = this.finishReason.get();
        if (aiMessage.hasToolExecutionRequests()) {
            finishReason = FinishReason.TOOL_EXECUTION;
        }
        return ChatResponse.builder().aiMessage(aiMessage).metadata(ChatResponseMetadata.builder().id(this.id.get()).modelName(this.modelName.get()).tokenUsage(this.tokenUsage.get()).finishReason(finishReason).build()).build();
    }

    private void updateId(GenerateContentResponse response) {
        if (!Utils.isNullOrBlank((String)response.responseId())) {
            this.id.set(response.responseId());
        }
    }

    private void updateModelName(GenerateContentResponse response) {
        if (!Utils.isNullOrBlank((String)response.modelVersion())) {
            this.modelName.set(response.modelVersion());
        }
    }

    private void updateTokenUsage(GenerateContentResponse.UsageMetadata usageMetadata) {
        if (usageMetadata != null) {
            TokenUsage tokenUsage = new TokenUsage(usageMetadata.promptTokenCount(), usageMetadata.candidatesTokenCount(), usageMetadata.totalTokenCount());
            this.tokenUsage.set(tokenUsage);
        }
    }

    private void updateFinishReason(GenerateContentResponse.Candidate candidate) {
        if (candidate.finishReason() != null) {
            this.finishReason.set(GeminiStreamingResponseBuilder.fromGFinishReasonToFinishReason(candidate.finishReason()));
        }
    }

    private void updateContentAndFunctionCalls(AiMessage message) {
        Optional.ofNullable(message.text()).ifPresent(this.contentBuilder::append);
        if (message.hasToolExecutionRequests()) {
            this.functionCalls.addAll(message.toolExecutionRequests());
        }
    }

    private AiMessage createAiMessage() {
        String text = this.contentBuilder.toString();
        return AiMessage.builder().text(text.isEmpty() ? null : text).toolExecutionRequests(this.functionCalls).build();
    }

    static AiMessage fromGPartsToAiMessage(List<GenerateContentResponse.Candidate.Part> parts) {
        StringBuilder fullText = new StringBuilder();
        ArrayList<FunctionCall> functionCalls = new ArrayList<FunctionCall>();
        for (GenerateContentResponse.Candidate.Part part : parts) {
            String text = part.text();
            if (text != null && !text.isEmpty()) {
                if (!fullText.isEmpty()) {
                    fullText.append("\n\n");
                }
                fullText.append(text);
            }
            if (part.functionCall() == null) continue;
            functionCalls.add(part.functionCall());
        }
        if (functionCalls.isEmpty()) {
            return AiMessage.from((String)fullText.toString());
        }
        return AiMessage.from(GeminiStreamingResponseBuilder.fromToolExecReqToGFunCall(functionCalls));
    }

    static List<ToolExecutionRequest> fromToolExecReqToGFunCall(List<FunctionCall> functionCalls) {
        return functionCalls.stream().map(functionCall -> {
            try {
                return ToolExecutionRequest.builder().name(functionCall.name()).arguments(QuarkusJsonCodecFactory.ObjectMapperHolder.MAPPER.writeValueAsString(functionCall.args())).build();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    static FinishReason fromGFinishReasonToFinishReason(GenerateContentResponse.FinishReason geminiFinishReason) {
        switch (geminiFinishReason) {
            case STOP: {
                return FinishReason.STOP;
            }
            case BLOCKLIST: 
            case PROHIBITED_CONTENT: 
            case RECITATION: 
            case SPII: 
            case SAFETY: 
            case LANGUAGE: {
                return FinishReason.CONTENT_FILTER;
            }
            case MAX_TOKENS: {
                return FinishReason.LENGTH;
            }
            case MALFORMED_FUNCTION_CALL: 
            case FINISH_REASON_UNSPECIFIED: 
            case OTHER: {
                return FinishReason.OTHER;
            }
        }
        return FinishReason.OTHER;
    }
}

