/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.huggingface;

import dev.langchain4j.model.huggingface.client.EmbeddingRequest;
import dev.langchain4j.model.huggingface.client.HuggingFaceClient;
import dev.langchain4j.model.huggingface.client.TextGenerationRequest;
import dev.langchain4j.model.huggingface.client.TextGenerationResponse;
import dev.langchain4j.model.huggingface.spi.HuggingFaceClientFactory;
import io.quarkiverse.langchain4j.huggingface.HuggingFaceRestApi;
import io.quarkus.rest.client.reactive.QuarkusRestClientBuilder;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class QuarkusHuggingFaceClientFactory
implements HuggingFaceClientFactory {
    public HuggingFaceClient create(HuggingFaceClientFactory.Input input) {
        throw new UnsupportedOperationException("Should not be called");
    }

    public HuggingFaceClient create(HuggingFaceClientFactory.Input input, URI url) {
        HuggingFaceRestApi restApi = (HuggingFaceRestApi)QuarkusRestClientBuilder.newBuilder().baseUri(url).connectTimeout(input.timeout().toSeconds(), TimeUnit.SECONDS).readTimeout(input.timeout().toSeconds(), TimeUnit.SECONDS).build(HuggingFaceRestApi.class);
        return new QuarkusHuggingFaceClient(restApi, input.apiKey());
    }

    public static class QuarkusHuggingFaceClient
    implements HuggingFaceClient {
        private final HuggingFaceRestApi restApi;
        private final String token;

        public QuarkusHuggingFaceClient(HuggingFaceRestApi restApi, String token) {
            this.restApi = restApi;
            this.token = token;
        }

        public TextGenerationResponse chat(TextGenerationRequest request) {
            return this.generate(request);
        }

        public TextGenerationResponse generate(TextGenerationRequest request) {
            return QuarkusHuggingFaceClient.toOneResponse(this.restApi.generate(request, this.token));
        }

        private static TextGenerationResponse toOneResponse(List<TextGenerationResponse> responses) {
            if (responses != null && responses.size() == 1) {
                return responses.get(0);
            }
            throw new RuntimeException("Expected only one generated_text, but was: " + (responses == null ? 0 : responses.size()));
        }

        public List<float[]> embed(EmbeddingRequest request) {
            return this.restApi.embed(request, this.token);
        }
    }
}

