/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.huggingface;

import dev.langchain4j.model.huggingface.client.EmbeddingRequest;
import dev.langchain4j.model.huggingface.client.HuggingFaceClient;
import dev.langchain4j.model.huggingface.client.TextGenerationRequest;
import dev.langchain4j.model.huggingface.client.TextGenerationResponse;
import dev.langchain4j.model.huggingface.spi.HuggingFaceClientFactory;
import io.quarkiverse.langchain4j.huggingface.HuggingFaceRestApi;
import io.quarkiverse.langchain4j.huggingface.QuarkusHuggingFaceChatModel;
import io.quarkus.rest.client.reactive.QuarkusRestClientBuilder;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.api.LoggingScope;

public class QuarkusHuggingFaceClientFactory
implements HuggingFaceClientFactory {
    public HuggingFaceClient create(HuggingFaceClientFactory.Input input) {
        throw new UnsupportedOperationException("Should not be called");
    }

    public HuggingFaceClient create(QuarkusHuggingFaceChatModel.Builder config, HuggingFaceClientFactory.Input input, URI url) {
        QuarkusRestClientBuilder builder = QuarkusRestClientBuilder.newBuilder().baseUri(url).connectTimeout(input.timeout().toSeconds(), TimeUnit.SECONDS).readTimeout(input.timeout().toSeconds(), TimeUnit.SECONDS);
        if (config != null && (config.logRequests || config.logResponses)) {
            builder.loggingScope(LoggingScope.REQUEST_RESPONSE);
            builder.clientLogger((ClientLogger)new HuggingFaceClientLogger(config.logRequests, config.logResponses));
        }
        HuggingFaceRestApi restApi = (HuggingFaceRestApi)builder.build(HuggingFaceRestApi.class);
        return new QuarkusHuggingFaceClient(restApi, input.apiKey());
    }

    class HuggingFaceClientLogger
    implements ClientLogger {
        private static final Logger log = Logger.getLogger(HuggingFaceClientLogger.class);
        private static final Pattern BEARER_PATTERN = Pattern.compile("(Bearer\\s*sk-)(\\w{2})(\\w+)(\\w{2})");
        private final boolean logRequests;
        private final boolean logResponses;

        public HuggingFaceClientLogger(boolean logRequests, boolean logResponses) {
            this.logRequests = logRequests;
            this.logResponses = logResponses;
        }

        public void setBodySize(int bodySize) {
        }

        public void logRequest(HttpClientRequest request, Buffer body, boolean omitBody) {
            if (!this.logRequests || !log.isInfoEnabled()) {
                return;
            }
            try {
                log.infof("Request:\n- method: %s\n- url: %s\n- headers: %s\n- body: %s", new Object[]{request.getMethod(), request.absoluteURI(), this.inOneLine(request.headers()), this.bodyToString(body)});
            }
            catch (Exception e) {
                log.warn((Object)"Failed to log request", (Throwable)e);
            }
        }

        public void logResponse(final HttpClientResponse response, boolean redirect) {
            if (!this.logResponses || !log.isInfoEnabled()) {
                return;
            }
            response.bodyHandler((Handler)new Handler<Buffer>(this){
                final /* synthetic */ HuggingFaceClientLogger this$1;
                {
                    this.this$1 = this$1;
                }

                public void handle(Buffer body) {
                    try {
                        log.infof("Response:\n- status code: %s\n- headers: %s\n- body: %s", (Object)response.statusCode(), (Object)this.this$1.inOneLine(response.headers()), (Object)this.this$1.bodyToString(body));
                    }
                    catch (Exception e) {
                        log.warn((Object)"Failed to log response", (Throwable)e);
                    }
                }
            });
        }

        private String bodyToString(Buffer body) {
            if (body == null) {
                return "";
            }
            return body.toString();
        }

        private String inOneLine(MultiMap headers) {
            return StreamSupport.stream(headers.spliterator(), false).map(header -> {
                String headerKey = (String)header.getKey();
                String headerValue = (String)header.getValue();
                if (headerKey.equals("Authorization")) {
                    headerValue = HuggingFaceClientLogger.maskAuthorizationHeaderValue(headerValue);
                } else if (headerKey.equals("api-key")) {
                    headerValue = HuggingFaceClientLogger.maskApiKeyHeaderValue(headerValue);
                }
                return String.format("[%s: %s]", headerKey, headerValue);
            }).collect(Collectors.joining(", "));
        }

        private static String maskAuthorizationHeaderValue(String authorizationHeaderValue) {
            try {
                Matcher matcher = BEARER_PATTERN.matcher(authorizationHeaderValue);
                StringBuilder sb = new StringBuilder();
                while (matcher.find()) {
                    matcher.appendReplacement(sb, matcher.group(1) + matcher.group(2) + "..." + matcher.group(4));
                }
                matcher.appendTail(sb);
                return sb.toString();
            }
            catch (Exception e) {
                return "Failed to mask the API key.";
            }
        }

        private static String maskApiKeyHeaderValue(String apiKeyHeaderValue) {
            try {
                if (apiKeyHeaderValue.length() <= 4) {
                    return apiKeyHeaderValue;
                }
                return apiKeyHeaderValue.substring(0, 2) + "..." + apiKeyHeaderValue.substring(apiKeyHeaderValue.length() - 2);
            }
            catch (Exception e) {
                return "Failed to mask the API key.";
            }
        }
    }

    public static class QuarkusHuggingFaceClient
    implements HuggingFaceClient {
        private final HuggingFaceRestApi restApi;
        private final String token;

        public QuarkusHuggingFaceClient(HuggingFaceRestApi restApi, String token) {
            this.restApi = restApi;
            this.token = token;
        }

        public TextGenerationResponse chat(TextGenerationRequest request) {
            return this.generate(request);
        }

        public TextGenerationResponse generate(TextGenerationRequest request) {
            return QuarkusHuggingFaceClient.toOneResponse(this.restApi.generate(request, this.token));
        }

        private static TextGenerationResponse toOneResponse(List<TextGenerationResponse> responses) {
            if (responses != null && responses.size() == 1) {
                return responses.get(0);
            }
            throw new RuntimeException("Expected only one generated_text, but was: " + (responses == null ? 0 : responses.size()));
        }

        public List<float[]> embed(EmbeddingRequest request) {
            return this.restApi.embed(request, this.token);
        }
    }
}

