/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.jaxrsclient;

import dev.langchain4j.exception.HttpException;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.http.client.sse.ServerSentEventParser;
import io.quarkiverse.langchain4j.jaxrsclient.JaxRsHttpClientBuilder;
import io.quarkus.tls.TlsConfiguration;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.TrustOptions;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.security.KeyStore;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.jboss.resteasy.reactive.client.TlsConfig;
import org.jboss.resteasy.reactive.client.impl.ClientBuilderImpl;

public class JaxRsHttpClient
implements HttpClient {
    private final Client delegate;

    public JaxRsHttpClient(JaxRsHttpClientBuilder builder) {
        ClientBuilderImpl clientBuilder = (ClientBuilderImpl)new ClientBuilderImpl().connectTimeout(builder.connectTimeout().getSeconds(), TimeUnit.SECONDS).readTimeout(builder.readTimeout().getSeconds(), TimeUnit.SECONDS);
        for (Object provider : builder.clientProviders()) {
            clientBuilder.register(provider);
        }
        if (builder.tlsConfiguration() != null) {
            final TlsConfiguration tlsConfiguration = builder.tlsConfiguration();
            clientBuilder.tlsConfig(new TlsConfig(){
                final /* synthetic */ JaxRsHttpClient this$0;
                {
                    this.this$0 = this$0;
                }

                public KeyStore getKeyStore() {
                    return tlsConfiguration.getKeyStore();
                }

                public KeyCertOptions getKeyStoreOptions() {
                    return tlsConfiguration.getKeyStoreOptions();
                }

                public KeyStore getTrustStore() {
                    return tlsConfiguration.getTrustStore();
                }

                public TrustOptions getTrustStoreOptions() {
                    return tlsConfiguration.getTrustStoreOptions();
                }

                public SSLOptions getSSLOptions() {
                    return tlsConfiguration.getSSLOptions();
                }

                public SSLContext createSSLContext() throws Exception {
                    return tlsConfiguration.createSSLContext();
                }

                public Optional<String> getHostnameVerificationAlgorithm() {
                    return tlsConfiguration.getHostnameVerificationAlgorithm();
                }

                public boolean usesSni() {
                    return tlsConfiguration.usesSni();
                }

                public boolean isTrustAll() {
                    return tlsConfiguration.isTrustAll();
                }

                public Optional<String> getName() {
                    throw new IllegalStateException("this should not be called");
                }
            });
        }
        this.delegate = clientBuilder.build();
    }

    public static JaxRsHttpClientBuilder builder() {
        return new JaxRsHttpClientBuilder();
    }

    public SuccessfulHttpResponse execute(HttpRequest request) {
        Response response;
        WebTarget target = this.delegate.target(request.url());
        Invocation.Builder invocationBuilder = target.request();
        for (Map.Entry headers : request.headers().entrySet()) {
            List values = (List)headers.getValue();
            if (values == null || values.isEmpty()) continue;
            invocationBuilder.header((String)headers.getKey(), (Object)values);
        }
        switch (request.method()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case GET: {
                Response response2 = invocationBuilder.get();
                break;
            }
            case POST: {
                Response response2 = invocationBuilder.post(Entity.json((Object)request.body()));
                break;
            }
            case DELETE: {
                Response response2 = response = invocationBuilder.delete();
            }
        }
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw new HttpException(response.getStatus(), (String)response.readEntity(String.class));
        }
        return SuccessfulHttpResponse.builder().statusCode(response.getStatus()).headers((Map)response.getStringHeaders()).body((String)response.readEntity(String.class)).build();
    }

    public void execute(HttpRequest request, ServerSentEventParser parser, ServerSentEventListener listener) {
    }
}

