/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.jlama.deployment;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.github.tjake.jlama.safetensors.SafeTensorSupport;
import com.github.tjake.jlama.util.ProgressReporter;
import io.quarkiverse.langchain4j.ModelName;
import io.quarkiverse.langchain4j.deployment.LangChain4jDotNames;
import io.quarkiverse.langchain4j.deployment.items.ChatModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.EmbeddingModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedChatModelProviderBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedEmbeddingModelCandidateBuildItem;
import io.quarkiverse.langchain4j.jlama.JlamaModelRegistry;
import io.quarkiverse.langchain4j.jlama.deployment.LangChain4jJlamaBuildTimeConfig;
import io.quarkiverse.langchain4j.jlama.runtime.JlamaAiRecorder;
import io.quarkiverse.langchain4j.jlama.runtime.config.LangChain4jJlamaConfig;
import io.quarkiverse.langchain4j.jlama.runtime.config.LangChain4jJlamaFixedRuntimeConfig;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.file.PathUtils;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JlamaProcessor {
    private static final org.jboss.logging.Logger LOGGER = org.jboss.logging.Logger.getLogger(JlamaProcessor.class);
    private static final String FEATURE = "langchain4j-jlama";
    private static final String PROVIDER = "jlama";
    private static final Logger log = LoggerFactory.getLogger(JlamaProcessor.class);

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void nativeSupport(BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer) {
        reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{PropertyNamingStrategies.SnakeCaseStrategy.class}).build());
    }

    @BuildStep
    public void providerCandidates(BuildProducer<ChatModelProviderCandidateBuildItem> chatProducer, BuildProducer<EmbeddingModelProviderCandidateBuildItem> embeddingProducer, LangChain4jJlamaBuildTimeConfig config) {
        if (config.chatModel().enabled().isEmpty() || config.chatModel().enabled().get().booleanValue()) {
            chatProducer.produce((BuildItem)new ChatModelProviderCandidateBuildItem(PROVIDER));
        }
        if (config.embeddingModel().enabled().isEmpty() || config.embeddingModel().enabled().get().booleanValue()) {
            embeddingProducer.produce((BuildItem)new EmbeddingModelProviderCandidateBuildItem(PROVIDER));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void generateBeans(JlamaAiRecorder recorder, List<SelectedChatModelProviderBuildItem> selectedChatItem, List<SelectedEmbeddingModelCandidateBuildItem> selectedEmbedding, LangChain4jJlamaConfig runtimeConfig, LangChain4jJlamaFixedRuntimeConfig fixedRuntimeConfig, BuildProducer<SyntheticBeanBuildItem> beanProducer) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator builder;
        String configName;
        for (SelectedChatModelProviderBuildItem selectedChatModelProviderBuildItem : selectedChatItem) {
            if (!PROVIDER.equals(selectedChatModelProviderBuildItem.getProvider())) continue;
            configName = selectedChatModelProviderBuildItem.getConfigName();
            builder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)LangChain4jDotNames.CHAT_MODEL).setRuntimeInit().defaultBean()).scope(ApplicationScoped.class)).supplier(recorder.chatModel(runtimeConfig, fixedRuntimeConfig, configName));
            this.addQualifierIfNecessary(builder, configName);
            beanProducer.produce((BuildItem)builder.done());
            SyntheticBeanBuildItem.ExtendedBeanConfigurator streamingBuilder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)LangChain4jDotNames.STREAMING_CHAT_MODEL).setRuntimeInit().defaultBean()).scope(ApplicationScoped.class)).supplier(recorder.streamingChatModel(runtimeConfig, fixedRuntimeConfig, configName));
            this.addQualifierIfNecessary(streamingBuilder, configName);
            beanProducer.produce((BuildItem)streamingBuilder.done());
        }
        for (SelectedEmbeddingModelCandidateBuildItem selectedEmbeddingModelCandidateBuildItem : selectedEmbedding) {
            if (!PROVIDER.equals(selectedEmbeddingModelCandidateBuildItem.getProvider())) continue;
            configName = selectedEmbeddingModelCandidateBuildItem.getConfigName();
            builder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)LangChain4jDotNames.EMBEDDING_MODEL).setRuntimeInit().defaultBean()).unremovable()).scope(ApplicationScoped.class)).supplier(recorder.embeddingModel(runtimeConfig, fixedRuntimeConfig, configName));
            this.addQualifierIfNecessary(builder, configName);
            beanProducer.produce((BuildItem)builder.done());
        }
    }

    private void addQualifierIfNecessary(SyntheticBeanBuildItem.ExtendedBeanConfigurator builder, String configName) {
        if (!NamedConfigUtil.isDefault((String)configName)) {
            builder.addQualifier(AnnotationInstance.builder(ModelName.class).add("value", configName).build());
        }
    }

    @Produce(value=ServiceStartBuildItem.class)
    @BuildStep
    void downloadModels(List<SelectedChatModelProviderBuildItem> selectedChatModels, List<SelectedEmbeddingModelCandidateBuildItem> selectedEmbeddingModels, LoggingSetupBuildItem loggingSetupBuildItem, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LaunchModeBuildItem launchMode, LangChain4jJlamaBuildTimeConfig buildTimeConfig, LangChain4jJlamaFixedRuntimeConfig fixedRuntimeConfig, BuildProducer<ModelDownloadedBuildItem> modelDownloadedProducer) {
        if (!buildTimeConfig.includeModelsInArtifact()) {
            return;
        }
        JlamaModelRegistry registry = JlamaModelRegistry.getOrCreate((Optional)fixedRuntimeConfig.modelsPath());
        final BigDecimal ONE_HUNDRED = new BigDecimal("100");
        if (buildTimeConfig.chatModel().enabled().orElse(true).booleanValue() || buildTimeConfig.embeddingModel().enabled().orElse(true).booleanValue()) {
            String modelName;
            String configName;
            ArrayList<String> modelsNeeded = new ArrayList<String>();
            for (SelectedChatModelProviderBuildItem selectedChatModelProviderBuildItem : selectedChatModels) {
                if (!PROVIDER.equals(selectedChatModelProviderBuildItem.getProvider())) continue;
                configName = selectedChatModelProviderBuildItem.getConfigName();
                modelName = NamedConfigUtil.isDefault((String)configName) ? fixedRuntimeConfig.defaultConfig().chatModel().modelName() : ((LangChain4jJlamaFixedRuntimeConfig.JlamaConfig)fixedRuntimeConfig.namedConfig().get(configName)).chatModel().modelName();
                modelsNeeded.add(modelName);
            }
            for (SelectedEmbeddingModelCandidateBuildItem selectedEmbeddingModelCandidateBuildItem : selectedEmbeddingModels) {
                if (!PROVIDER.equals(selectedEmbeddingModelCandidateBuildItem.getProvider())) continue;
                configName = selectedEmbeddingModelCandidateBuildItem.getConfigName();
                modelName = NamedConfigUtil.isDefault((String)configName) ? fixedRuntimeConfig.defaultConfig().embeddingModel().modelName() : ((LangChain4jJlamaFixedRuntimeConfig.JlamaConfig)fixedRuntimeConfig.namedConfig().get(configName)).embeddingModel().modelName();
                modelsNeeded.add(modelName);
            }
            if (!modelsNeeded.isEmpty()) {
                StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Jlama model pull:", consoleInstalledBuildItem, loggingSetupBuildItem);
                for (final String modelName2 : modelsNeeded) {
                    JlamaModelRegistry.ModelInfo modelInfo = JlamaModelRegistry.ModelInfo.from((String)modelName2);
                    Path pathOfModelDirOnDisk = SafeTensorSupport.constructLocalModelPath((String)registry.getModelCachePath().toAbsolutePath().toString(), (String)modelInfo.owner(), (String)modelInfo.name());
                    if (Files.exists(pathOfModelDirOnDisk.resolve(".finished"), new LinkOption[0])) {
                        LOGGER.debug((Object)("Model " + modelName2 + "already exists in " + String.valueOf(pathOfModelDirOnDisk)));
                    } else {
                        LOGGER.info((Object)("Pulling model " + modelName2));
                        final AtomicReference LAST_UPDATE_REF = new AtomicReference();
                        try {
                            registry.downloadModel(modelName2, Optional.empty(), Optional.of(new ProgressReporter(){

                                public void update(String filename, long sizeDownloaded, long totalSize) {
                                    if (totalSize < 100000L) {
                                        return;
                                    }
                                    if (!this.logUpdate((Long)LAST_UPDATE_REF.get())) {
                                        return;
                                    }
                                    LAST_UPDATE_REF.set(System.nanoTime());
                                    BigDecimal percentage = new BigDecimal(sizeDownloaded).divide(new BigDecimal(totalSize), 4, RoundingMode.HALF_DOWN).multiply(ONE_HUNDRED);
                                    BigDecimal progress = percentage.setScale(2, RoundingMode.HALF_DOWN);
                                    if (progress.compareTo(ONE_HUNDRED) >= 0) {
                                        LOGGER.infof("Verifying and cleaning up\n", (Object)progress);
                                    } else {
                                        LOGGER.infof("%s - Progress: %s%%\n", (Object)modelName2, (Object)progress);
                                    }
                                }

                                private boolean logUpdate(Long lastUpdate) {
                                    if (lastUpdate == null) {
                                        return true;
                                    }
                                    return TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - TimeUnit.NANOSECONDS.toMillis(lastUpdate) > 1000L;
                                }
                            }));
                        }
                        catch (IOException e) {
                            compressor.closeAndDumpCaptured();
                            throw new UncheckedIOException(e);
                        }
                    }
                    modelDownloadedProducer.produce((BuildItem)new ModelDownloadedBuildItem(modelName2, pathOfModelDirOnDisk));
                }
                compressor.close();
            }
        }
    }

    @BuildStep(onlyIf={IsNormal.class})
    @Produce(value=ArtifactResultBuildItem.class)
    public void copyToFastJar(List<ModelDownloadedBuildItem> models, Optional<JarBuildItem> jarBuildItem) {
        if (!jarBuildItem.isPresent()) {
            return;
        }
        Path jarPath = jarBuildItem.get().getPath();
        if (!"quarkus-run.jar".equals(jarPath.getFileName().toString())) {
            return;
        }
        Path quarkusAppDir = jarPath.getParent();
        Path jlamaInQuarkusAppDir = quarkusAppDir.resolve(PROVIDER);
        for (ModelDownloadedBuildItem bi : new LinkedHashSet<ModelDownloadedBuildItem>(models)) {
            try {
                JlamaModelRegistry.ModelInfo modelInfo = JlamaModelRegistry.ModelInfo.from((String)bi.getModelName());
                Path targetDir = jlamaInQuarkusAppDir.resolve(modelInfo.toFileName());
                Files.createDirectories(targetDir, new FileAttribute[0]);
                PathUtils.copyDirectory((Path)bi.getDirectory(), (Path)targetDir, (CopyOption[])new CopyOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static final class ModelDownloadedBuildItem
    extends MultiBuildItem {
        private final String modelName;
        private final Path directory;

        public ModelDownloadedBuildItem(String modelName, Path directory) {
            this.modelName = modelName;
            this.directory = directory;
        }

        public String getModelName() {
            return this.modelName;
        }

        public Path getDirectory() {
            return this.directory;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ModelDownloadedBuildItem)) {
                return false;
            }
            ModelDownloadedBuildItem that = (ModelDownloadedBuildItem)((Object)o);
            return Objects.equals(this.modelName, that.modelName) && Objects.equals(this.directory, that.directory);
        }

        public int hashCode() {
            return Objects.hash(this.modelName, this.directory);
        }
    }
}

