/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.jlama;

import com.github.tjake.jlama.model.ModelSupport;
import com.github.tjake.jlama.safetensors.SafeTensorSupport;
import com.github.tjake.jlama.util.ProgressReporter;
import io.quarkiverse.langchain4j.jlama.JlamaModel;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;

public class JlamaModelRegistry {
    private static final String DEFAULT_MODEL_CACHE_PATH = System.getProperty("user.home", "") + File.separator + ".langchain4j" + File.separator + "models";
    private final Path modelCachePath;

    private JlamaModelRegistry(Path modelCachePath) {
        this.modelCachePath = modelCachePath;
        if (!Files.exists(modelCachePath, new LinkOption[0])) {
            try {
                Files.createDirectories(modelCachePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    public static JlamaModelRegistry getOrCreate(Optional<Path> modelCachePath) {
        return new JlamaModelRegistry(modelCachePath.orElse(Path.of(DEFAULT_MODEL_CACHE_PATH, new String[0])));
    }

    public Path getModelCachePath() {
        return this.modelCachePath;
    }

    public JlamaModel downloadModel(String modelName, Optional<String> authToken) throws IOException {
        return this.downloadModel(modelName, authToken, Optional.empty());
    }

    public JlamaModel downloadModel(String modelName, Optional<String> authToken, Optional<ProgressReporter> progressReporter) throws IOException {
        ModelInfo modelInfo = ModelInfo.from(modelName);
        File modelDir = SafeTensorSupport.maybeDownloadModel((String)this.modelCachePath.toString(), Optional.ofNullable(modelInfo.owner), (String)modelInfo.name, (boolean)true, Optional.empty(), authToken, progressReporter);
        File config = new File(modelDir, "config.json");
        ModelSupport.ModelType type = SafeTensorSupport.detectModel((File)config);
        return new JlamaModel(this, type, modelDir.getName(), Optional.empty(), modelName, true);
    }

    public record ModelInfo(String owner, String name) {
        public static ModelInfo from(String modelName) {
            String name;
            String owner;
            String[] parts = modelName.split("/");
            if (parts.length == 0 || parts.length > 2) {
                throw new IllegalArgumentException("Model must be in the form owner/name");
            }
            if (parts.length == 1) {
                owner = null;
                name = modelName;
            } else {
                owner = parts[0];
                name = parts[1];
            }
            return new ModelInfo(owner, name);
        }

        public String toFileName() {
            return this.owner + "_" + this.name;
        }
    }
}

