/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.jlama.runtime.config;

import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class ModelsPathConfigSource
implements ConfigSource {
    private static final String SENTINEL = "#sen-val#";
    public static final String SUPPORTED_PROPERTY_NAME = "quarkus.langchain4j.jlama.models-path";
    private volatile String value = null;

    public String getName() {
        return "ModelsPathConfigSource";
    }

    public int getOrdinal() {
        return 100;
    }

    public Set<String> getPropertyNames() {
        return Set.of(SUPPORTED_PROPERTY_NAME);
    }

    public String getValue(String name) {
        if (!SUPPORTED_PROPERTY_NAME.equals(name)) {
            return null;
        }
        if (LaunchMode.current() != LaunchMode.NORMAL) {
            return null;
        }
        String result = this.value;
        if (result == null) {
            result = this.value = this.produceValue();
        }
        if (result.equals(SENTINEL)) {
            return null;
        }
        return result;
    }

    private String produceValue() {
        try {
            Class<?> clazz = Class.forName("io.quarkus.bootstrap.runner.QuarkusEntryPoint", false, Thread.currentThread().getContextClassLoader());
            String path = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
            if (path == null) {
                return SENTINEL;
            }
            String decodedPath = URLDecoder.decode(path, StandardCharsets.UTF_8);
            Path appRoot = new File(decodedPath).toPath().getParent().getParent().getParent();
            Path jlamaRoot = appRoot.resolve("jlama");
            if (Files.isDirectory(jlamaRoot, new LinkOption[0])) {
                return jlamaRoot.toAbsolutePath().toString();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return SENTINEL;
    }
}

