/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.mcp.runtime;

import dev.langchain4j.mcp.client.logging.McpLogMessage;
import dev.langchain4j.mcp.client.logging.McpLogMessageHandler;
import io.quarkiverse.langchain4j.mcp.runtime.McpClientName;
import io.quarkus.arc.Arc;
import java.lang.annotation.Annotation;
import org.jboss.logging.Logger;

public class QuarkusDefaultMcpLogHandler
implements McpLogMessageHandler {
    private static final Logger log = Logger.getLogger(QuarkusDefaultMcpLogHandler.class);
    private final String clientName;

    public QuarkusDefaultMcpLogHandler(String clientName) {
        this.clientName = clientName;
    }

    public void handleLogMessage(McpLogMessage message) {
        this.fireMessageAsCdiEvent(message);
        this.logMessage(message);
    }

    private void logMessage(McpLogMessage message) {
        if (message.level() == null) {
            log.warnf("Received MCP log message with unknown level: %s", (Object)message.data());
            return;
        }
        switch (message.level()) {
            case DEBUG: {
                log.debugf("MCP logger: %s: %s", (Object)message.logger(), (Object)message.data());
                break;
            }
            case INFO: 
            case NOTICE: {
                log.infof("MCP logger: %s: %s", (Object)message.logger(), (Object)message.data());
                break;
            }
            case WARNING: {
                log.warnf("MCP logger: %s: %s", (Object)message.logger(), (Object)message.data());
                break;
            }
            case ERROR: 
            case CRITICAL: 
            case ALERT: 
            case EMERGENCY: {
                log.errorf("MCP logger: %s: %s", (Object)message.logger(), (Object)message.data());
            }
        }
    }

    private void fireMessageAsCdiEvent(McpLogMessage message) {
        Arc.container().beanManager().getEvent().select(McpLogMessage.class, new Annotation[]{McpClientName.Literal.of(this.clientName)}).fire((Object)message);
    }
}

