/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.mcp.runtime;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.mcp.McpToolProvider;
import dev.langchain4j.mcp.client.McpClient;
import dev.langchain4j.service.tool.ToolProviderRequest;
import dev.langchain4j.service.tool.ToolProviderResult;
import io.quarkiverse.langchain4j.runtime.aiservice.QuarkusToolProviderRequest;
import java.util.List;
import java.util.function.BiPredicate;

public class QuarkusMcpToolProvider
extends McpToolProvider {
    QuarkusMcpToolProvider(List<McpClient> mcpClients) {
        super(mcpClients, false, (mcp, tool) -> true);
    }

    public ToolProviderResult provideTools(ToolProviderRequest request) {
        return this.provideTools(request, this.getMcpClientsFilter(request));
    }

    private BiPredicate<McpClient, ToolSpecification> getMcpClientsFilter(ToolProviderRequest request) {
        if (request instanceof QuarkusToolProviderRequest) {
            QuarkusToolProviderRequest quarkusRequest = (QuarkusToolProviderRequest)request;
            return new McpClientKeyFilter(quarkusRequest.getMcpClientNames());
        }
        return (mcp, tool) -> true;
    }

    private static class McpClientKeyFilter
    implements BiPredicate<McpClient, ToolSpecification> {
        private final List<String> keys;

        private McpClientKeyFilter(List<String> keys) {
            this.keys = keys;
        }

        @Override
        public boolean test(McpClient mcpClient, ToolSpecification tool) {
            return this.keys != null && (this.keys.isEmpty() || this.keys.stream().anyMatch(name -> name.equals(mcpClient.key())));
        }
    }
}

