/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.mcp.runtime.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.mcp.client.transport.McpOperationHandler;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.SseEvent;

public class SseSubscriber
implements Consumer<SseEvent<String>> {
    private final McpOperationHandler operationHandler;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger log = Logger.getLogger(SseSubscriber.class);
    private final boolean logEvents;
    private final CompletableFuture<String> initializationFinished;

    public SseSubscriber(McpOperationHandler operationHandler, boolean logEvents, CompletableFuture<String> initializationFinished) {
        this.operationHandler = operationHandler;
        this.logEvents = logEvents;
        this.initializationFinished = initializationFinished;
    }

    @Override
    public void accept(SseEvent<String> s) {
        String name;
        if (this.logEvents) {
            log.debug((Object)("< " + (String)s.data()));
        }
        if ((name = s.name()) == null) {
            log.warn((Object)"Received event with null name");
            return;
        }
        String data = (String)s.data();
        if (name.equals("message")) {
            if (this.logEvents) {
                log.debug((Object)("< " + data));
            }
            try {
                JsonNode jsonNode = OBJECT_MAPPER.readTree(data);
                this.operationHandler.handle(jsonNode);
            }
            catch (JsonProcessingException e) {
                log.warn("Failed to parse JSON message: {}", (Object)data, (Throwable)e);
            }
        } else if (name.equals("endpoint")) {
            if (this.initializationFinished.isDone()) {
                log.warn((Object)"Received endpoint event after initialization");
                return;
            }
            this.initializationFinished.complete((String)s.data());
        }
    }
}

