/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.mcp.runtime.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.mcp.client.protocol.InitializationNotification;
import dev.langchain4j.mcp.client.protocol.McpClientMessage;
import dev.langchain4j.mcp.client.protocol.McpInitializeRequest;
import dev.langchain4j.mcp.client.transport.McpOperationHandler;
import dev.langchain4j.mcp.client.transport.McpTransport;
import io.quarkiverse.langchain4j.mcp.auth.McpClientAuthProvider;
import io.quarkiverse.langchain4j.mcp.runtime.http.McpClientAuthFilter;
import io.quarkiverse.langchain4j.mcp.runtime.http.SseSubscriber;
import io.smallrye.mutiny.Uni;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.SseEvent;
import org.jboss.resteasy.reactive.common.util.MultivaluedTreeMap;

public class QuarkusStreamableHttpMcpTransport
implements McpTransport {
    private static final Logger log = Logger.getLogger(QuarkusStreamableHttpMcpTransport.class);
    private final String url;
    private final Duration timeout;
    private final boolean logResponses;
    private final boolean logRequests;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final AtomicReference<String> mcpSessionId = new AtomicReference();
    private volatile McpOperationHandler operationHandler;
    private final McpClientAuthProvider mcpClientAuthProvider;
    private final HttpClient httpClient;
    private volatile SseSubscriber sseSubscriber;
    private volatile Runnable onFailure;
    private volatile boolean closed;

    public QuarkusStreamableHttpMcpTransport(Builder builder) {
        this.url = (String)ValidationUtils.ensureNotNull((Object)builder.url, (String)"Missing MCP endpoint URL");
        this.timeout = (Duration)Utils.getOrDefault((Object)builder.timeout, (Object)Duration.ofSeconds(60L));
        this.httpClient = builder.httpClient;
        this.logRequests = builder.logRequests;
        this.logResponses = builder.logResponses;
        this.mcpClientAuthProvider = McpClientAuthProvider.resolve(builder.mcpClientName).orElse(null);
    }

    public void start(McpOperationHandler messageHandler) {
        this.operationHandler = messageHandler;
        this.sseSubscriber = new SseSubscriber(this.operationHandler, this.logResponses, null);
    }

    public CompletableFuture<JsonNode> initialize(McpInitializeRequest request) {
        return this.execute((McpClientMessage)request, request.getId()).onItem().transformToUni(response -> this.execute((McpClientMessage)new InitializationNotification(), null).onItem().transform(ignored -> response)).subscribeAsCompletionStage();
    }

    public void checkHealth() {
    }

    public void onFailure(Runnable actionOnFailure) {
        this.onFailure = actionOnFailure;
    }

    public CompletableFuture<JsonNode> executeOperationWithResponse(McpClientMessage operation) {
        return this.execute(operation, operation.getId()).subscribeAsCompletionStage();
    }

    public void executeOperationWithoutResponse(McpClientMessage operation) {
        this.execute(operation, null).subscribe().with(ignored -> {});
    }

    private Uni<JsonNode> execute(McpClientMessage request, Long id) {
        String authValue;
        CompletableFuture future = new CompletableFuture();
        Uni uni = Uni.createFrom().completionStage(future);
        if (id != null) {
            this.operationHandler.startOperation(id, future);
        }
        String body = null;
        try {
            body = this.objectMapper.writeValueAsString((Object)request);
        }
        catch (JsonProcessingException e) {
            future.completeExceptionally(e);
        }
        if (this.logRequests) {
            log.info((Object)("Request: " + body));
        }
        RequestOptions options = new RequestOptions().setAbsoluteURI(this.url).addHeader("Accept", "application/json,text/event-stream").setMethod(HttpMethod.POST);
        if (this.mcpSessionId.get() != null) {
            options.addHeader("Mcp-Session-Id", this.mcpSessionId.get());
        }
        if (this.mcpClientAuthProvider != null && (authValue = this.mcpClientAuthProvider.getAuthorization(new McpClientAuthFilter.AuthInputImpl("POST", URI.create(this.url), this.toMultivaluedMap(options.getHeaders())))) != null) {
            options.addHeader("Authorization", authValue);
        }
        String finalBody = body;
        this.httpClient.request(options).onComplete(result -> {
            if (result.failed()) {
                future.completeExceptionally(result.cause());
            } else {
                ((HttpClientRequest)result.result()).send(finalBody).onComplete(response -> {
                    if (response.failed()) {
                        future.completeExceptionally(response.cause());
                    } else if (this.isExpectedStatusCode(((HttpClientResponse)response.result()).statusCode())) {
                        String mcpSessionId = ((HttpClientResponse)response.result()).getHeader("Mcp-Session-Id");
                        if (mcpSessionId != null && !mcpSessionId.isEmpty()) {
                            log.debug((Object)("Assigned MCP session ID: " + mcpSessionId));
                            this.mcpSessionId.set(mcpSessionId);
                        }
                        String contentType = ((HttpClientResponse)response.result()).getHeader("Content-Type");
                        if (id != null && contentType != null && contentType.contains("text/event-stream")) {
                            ((HttpClientResponse)response.result()).handler(bodyBuffer -> {
                                String responseString = bodyBuffer.toString();
                                SseEvent<String> sseEvent = this.parseSseEvent(responseString);
                                this.sseSubscriber.accept(sseEvent);
                            });
                        } else {
                            if (id == null) {
                                future.complete(null);
                            }
                            ((HttpClientResponse)response.result()).bodyHandler(bodyBuffer -> {
                                try {
                                    String responseString = bodyBuffer.toString();
                                    JsonNode node = this.objectMapper.readTree(responseString);
                                    if (this.logResponses) {
                                        log.info((Object)("Response: " + responseString));
                                    }
                                    this.operationHandler.handle(node);
                                }
                                catch (JsonProcessingException e) {
                                    future.completeExceptionally(e);
                                }
                            });
                        }
                    } else {
                        future.completeExceptionally(new RuntimeException("Unexpected status code: " + ((HttpClientResponse)response.result()).statusCode()));
                    }
                });
            }
        });
        return uni;
    }

    private MultivaluedMap<String, Object> toMultivaluedMap(MultiMap multiMap) {
        MultivaluedTreeMap map = new MultivaluedTreeMap();
        multiMap.forEach((key, value) -> map.add(key, value));
        return map;
    }

    private SseEvent<String> parseSseEvent(String responseString) {
        final Map<String, String> entries = Arrays.stream(responseString.split("\\n")).collect(Collectors.toMap(s -> s.substring(0, s.indexOf(":")), s -> s.substring(s.indexOf(":") + 2)));
        return new SseEvent<String>(){
            final /* synthetic */ QuarkusStreamableHttpMcpTransport this$0;
            {
                this.this$0 = this$0;
            }

            public String id() {
                return (String)entries.get("id");
            }

            public String name() {
                return (String)entries.get("event");
            }

            public String comment() {
                return null;
            }

            public String data() {
                return (String)entries.get("data");
            }
        };
    }

    private boolean isExpectedStatusCode(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    public void close() throws IOException {
        this.closed = true;
        try {
            this.httpClient.close().toCompletionStage().toCompletableFuture().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        private String url;
        private String mcpClientName;
        private Duration timeout;
        private boolean logRequests = false;
        private boolean logResponses = false;
        private HttpClient httpClient;

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder mcpClientName(String mcpClientName) {
            this.mcpClientName = mcpClientName;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder logRequests(boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public Builder logResponses(boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public QuarkusStreamableHttpMcpTransport build() {
            return new QuarkusStreamableHttpMcpTransport(this);
        }
    }
}

