/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.mistralai.runtime;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.DisabledChatLanguageModel;
import dev.langchain4j.model.chat.DisabledStreamingChatLanguageModel;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.embedding.DisabledEmbeddingModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.mistralai.MistralAiChatModel;
import dev.langchain4j.model.mistralai.MistralAiEmbeddingModel;
import dev.langchain4j.model.mistralai.MistralAiModerationModel;
import dev.langchain4j.model.mistralai.MistralAiStreamingChatModel;
import dev.langchain4j.model.moderation.DisabledModerationModel;
import dev.langchain4j.model.moderation.ModerationModel;
import io.quarkiverse.langchain4j.mistralai.runtime.config.ChatModelConfig;
import io.quarkiverse.langchain4j.mistralai.runtime.config.EmbeddingModelConfig;
import io.quarkiverse.langchain4j.mistralai.runtime.config.LangChain4jMistralAiConfig;
import io.quarkiverse.langchain4j.mistralai.runtime.config.ModerationModelConfig;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkiverse.langchain4j.runtime.OptionalUtil;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.config.ConfigValidationException;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Supplier;

@Recorder
public class MistralAiRecorder {
    public Supplier<ChatLanguageModel> chatModel(LangChain4jMistralAiConfig runtimeConfig, String configName) {
        LangChain4jMistralAiConfig.MistralAiConfig mistralAiConfig = this.correspondingMistralAiConfig(runtimeConfig, configName);
        if (mistralAiConfig.enableIntegration().booleanValue()) {
            ChatModelConfig chatModelConfig = mistralAiConfig.chatModel();
            String apiKey = mistralAiConfig.apiKey();
            String baseUrl = mistralAiConfig.baseUrl();
            if ("dummy".equals(apiKey) && "https://api.mistral.ai/v1/".equals(baseUrl)) {
                throw new ConfigValidationException(this.createApiKeyConfigProblem(configName));
            }
            final MistralAiChatModel.MistralAiChatModelBuilder builder = MistralAiChatModel.builder().baseUrl(baseUrl).apiKey(apiKey).modelName(chatModelConfig.modelName()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logRequests(), mistralAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logResponses(), mistralAiConfig.logResponses()})).timeout(mistralAiConfig.timeout().orElse(Duration.ofSeconds(10L)));
            if (chatModelConfig.temperature().isPresent()) {
                builder.temperature(Double.valueOf(chatModelConfig.temperature().getAsDouble()));
            }
            if (chatModelConfig.topP().isPresent()) {
                builder.topP(Double.valueOf(chatModelConfig.topP().getAsDouble()));
            }
            if (chatModelConfig.maxTokens().isPresent()) {
                builder.maxTokens(Integer.valueOf(chatModelConfig.maxTokens().getAsInt()));
            }
            if (chatModelConfig.safePrompt().isPresent()) {
                builder.safePrompt(chatModelConfig.safePrompt().get());
            }
            if (chatModelConfig.randomSeed().isPresent()) {
                builder.randomSeed(Integer.valueOf(chatModelConfig.randomSeed().getAsInt()));
            }
            return new Supplier<ChatLanguageModel>(this){
                final /* synthetic */ MistralAiRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ChatLanguageModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<ChatLanguageModel>(){

            @Override
            public ChatLanguageModel get() {
                return new DisabledChatLanguageModel();
            }
        };
    }

    public Supplier<StreamingChatLanguageModel> streamingChatModel(LangChain4jMistralAiConfig runtimeConfig, String configName) {
        LangChain4jMistralAiConfig.MistralAiConfig mistralAiConfig = this.correspondingMistralAiConfig(runtimeConfig, configName);
        if (mistralAiConfig.enableIntegration().booleanValue()) {
            ChatModelConfig chatModelConfig = mistralAiConfig.chatModel();
            String apiKey = mistralAiConfig.apiKey();
            String baseUrl = mistralAiConfig.baseUrl();
            if ("dummy".equals(apiKey) && "https://api.mistral.ai/v1/".equals(baseUrl)) {
                throw new ConfigValidationException(this.createApiKeyConfigProblem(configName));
            }
            final MistralAiStreamingChatModel.MistralAiStreamingChatModelBuilder builder = MistralAiStreamingChatModel.builder().baseUrl(baseUrl).apiKey(apiKey).modelName(chatModelConfig.modelName()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logRequests(), mistralAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logResponses(), mistralAiConfig.logResponses()})).timeout(mistralAiConfig.timeout().orElse(Duration.ofSeconds(10L)));
            if (chatModelConfig.temperature().isPresent()) {
                builder.temperature(Double.valueOf(chatModelConfig.temperature().getAsDouble()));
            }
            if (chatModelConfig.topP().isPresent()) {
                builder.topP(Double.valueOf(chatModelConfig.topP().getAsDouble()));
            }
            if (chatModelConfig.maxTokens().isPresent()) {
                builder.maxTokens(Integer.valueOf(chatModelConfig.maxTokens().getAsInt()));
            }
            if (chatModelConfig.safePrompt().isPresent()) {
                builder.safePrompt(chatModelConfig.safePrompt().get());
            }
            if (chatModelConfig.randomSeed().isPresent()) {
                builder.randomSeed(Integer.valueOf(chatModelConfig.randomSeed().getAsInt()));
            }
            return new Supplier<StreamingChatLanguageModel>(this){
                final /* synthetic */ MistralAiRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public StreamingChatLanguageModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<StreamingChatLanguageModel>(){

            @Override
            public StreamingChatLanguageModel get() {
                return new DisabledStreamingChatLanguageModel();
            }
        };
    }

    public Supplier<EmbeddingModel> embeddingModel(LangChain4jMistralAiConfig runtimeConfig, String configName) {
        LangChain4jMistralAiConfig.MistralAiConfig mistralAiConfig = this.correspondingMistralAiConfig(runtimeConfig, configName);
        if (mistralAiConfig.enableIntegration().booleanValue()) {
            EmbeddingModelConfig embeddingModelConfig = mistralAiConfig.embeddingModel();
            String apiKey = mistralAiConfig.apiKey();
            String baseUrl = mistralAiConfig.baseUrl();
            if ("dummy".equals(apiKey) && "https://api.mistral.ai/v1/".equals(baseUrl)) {
                throw new ConfigValidationException(this.createApiKeyConfigProblem(configName));
            }
            final MistralAiEmbeddingModel.MistralAiEmbeddingModelBuilder builder = MistralAiEmbeddingModel.builder().baseUrl(mistralAiConfig.baseUrl()).apiKey(apiKey).modelName(embeddingModelConfig.modelName()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{embeddingModelConfig.logRequests(), mistralAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{embeddingModelConfig.logResponses(), mistralAiConfig.logResponses()})).timeout(mistralAiConfig.timeout().orElse(Duration.ofSeconds(10L)));
            return new Supplier<EmbeddingModel>(this){
                final /* synthetic */ MistralAiRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public EmbeddingModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<EmbeddingModel>(){

            @Override
            public EmbeddingModel get() {
                return new DisabledEmbeddingModel();
            }
        };
    }

    public Supplier<ModerationModel> moderationModel(LangChain4jMistralAiConfig runtimeConfig, String configName) {
        LangChain4jMistralAiConfig.MistralAiConfig mistralAiConfig = this.correspondingMistralAiConfig(runtimeConfig, configName);
        if (mistralAiConfig.enableIntegration().booleanValue()) {
            ModerationModelConfig moderationModelConfig = mistralAiConfig.moderationModel();
            String apiKey = mistralAiConfig.apiKey();
            String baseUrl = mistralAiConfig.baseUrl();
            if ("dummy".equals(apiKey) && "https://api.mistral.ai/v1/".equals(baseUrl)) {
                throw new ConfigValidationException(this.createApiKeyConfigProblem(configName));
            }
            final MistralAiModerationModel.Builder builder = new MistralAiModerationModel.Builder().baseUrl(baseUrl).apiKey(apiKey).modelName(moderationModelConfig.modelName()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{moderationModelConfig.logRequests(), mistralAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{moderationModelConfig.logResponses(), mistralAiConfig.logResponses()})).timeout(mistralAiConfig.timeout().orElse(Duration.ofSeconds(10L)));
            return new Supplier<ModerationModel>(this){
                final /* synthetic */ MistralAiRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ModerationModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<ModerationModel>(){

            @Override
            public ModerationModel get() {
                return new DisabledModerationModel();
            }
        };
    }

    private LangChain4jMistralAiConfig.MistralAiConfig correspondingMistralAiConfig(LangChain4jMistralAiConfig runtimeConfig, String configName) {
        LangChain4jMistralAiConfig.MistralAiConfig config = NamedConfigUtil.isDefault((String)configName) ? runtimeConfig.defaultConfig() : runtimeConfig.namedConfig().get(configName);
        return config;
    }

    private ConfigValidationException.Problem[] createApiKeyConfigProblem(String configName) {
        return this.createConfigProblems("api-key", configName);
    }

    private ConfigValidationException.Problem[] createConfigProblems(String key, String configName) {
        return new ConfigValidationException.Problem[]{MistralAiRecorder.createConfigProblem(key, configName)};
    }

    private static ConfigValidationException.Problem createConfigProblem(String key, String configName) {
        return new ConfigValidationException.Problem(String.format("SRCFG00014: The config property quarkus.langchain4j.mistralai%s%s is required but it could not be found in any config source", NamedConfigUtil.isDefault((String)configName) ? "." : "." + configName + ".", key));
    }
}

