/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.mistralai.runtime;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.DisabledChatModel;
import dev.langchain4j.model.chat.DisabledStreamingChatModel;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.embedding.DisabledEmbeddingModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.mistralai.MistralAiChatModel;
import dev.langchain4j.model.mistralai.MistralAiEmbeddingModel;
import dev.langchain4j.model.mistralai.MistralAiModerationModel;
import dev.langchain4j.model.mistralai.MistralAiStreamingChatModel;
import dev.langchain4j.model.moderation.DisabledModerationModel;
import dev.langchain4j.model.moderation.ModerationModel;
import io.quarkiverse.langchain4j.mistralai.runtime.config.ChatModelConfig;
import io.quarkiverse.langchain4j.mistralai.runtime.config.EmbeddingModelConfig;
import io.quarkiverse.langchain4j.mistralai.runtime.config.LangChain4jMistralAiConfig;
import io.quarkiverse.langchain4j.mistralai.runtime.config.ModerationModelConfig;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkiverse.langchain4j.runtime.OptionalUtil;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.config.ConfigValidationException;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Supplier;

@Recorder
public class MistralAiRecorder {
    private final RuntimeValue<LangChain4jMistralAiConfig> runtimeConfig;

    public MistralAiRecorder(RuntimeValue<LangChain4jMistralAiConfig> runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    public Supplier<ChatModel> chatModel(String configName) {
        LangChain4jMistralAiConfig.MistralAiConfig mistralAiConfig = this.correspondingMistralAiConfig(configName);
        if (mistralAiConfig.enableIntegration().booleanValue()) {
            ChatModelConfig chatModelConfig = mistralAiConfig.chatModel();
            String apiKey = mistralAiConfig.apiKey();
            String baseUrl = mistralAiConfig.baseUrl();
            if ("dummy".equals(apiKey) && "https://api.mistral.ai/v1/".equals(baseUrl)) {
                throw new ConfigValidationException(this.createApiKeyConfigProblem(configName));
            }
            final MistralAiChatModel.MistralAiChatModelBuilder builder = MistralAiChatModel.builder().baseUrl(baseUrl).apiKey(apiKey).modelName(chatModelConfig.modelName()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logRequests(), mistralAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logResponses(), mistralAiConfig.logResponses()})).timeout(mistralAiConfig.timeout().orElse(Duration.ofSeconds(10L)));
            if (chatModelConfig.temperature().isPresent()) {
                builder.temperature(Double.valueOf(chatModelConfig.temperature().getAsDouble()));
            }
            if (chatModelConfig.topP().isPresent()) {
                builder.topP(Double.valueOf(chatModelConfig.topP().getAsDouble()));
            }
            if (chatModelConfig.maxTokens().isPresent()) {
                builder.maxTokens(Integer.valueOf(chatModelConfig.maxTokens().getAsInt()));
            }
            if (chatModelConfig.safePrompt().isPresent()) {
                builder.safePrompt(chatModelConfig.safePrompt().get());
            }
            if (chatModelConfig.randomSeed().isPresent()) {
                builder.randomSeed(Integer.valueOf(chatModelConfig.randomSeed().getAsInt()));
            }
            return new Supplier<ChatModel>(this){
                final /* synthetic */ MistralAiRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ChatModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<ChatModel>(){

            @Override
            public ChatModel get() {
                return new DisabledChatModel();
            }
        };
    }

    public Supplier<StreamingChatModel> streamingChatModel(String configName) {
        LangChain4jMistralAiConfig.MistralAiConfig mistralAiConfig = this.correspondingMistralAiConfig(configName);
        if (mistralAiConfig.enableIntegration().booleanValue()) {
            ChatModelConfig chatModelConfig = mistralAiConfig.chatModel();
            String apiKey = mistralAiConfig.apiKey();
            String baseUrl = mistralAiConfig.baseUrl();
            if ("dummy".equals(apiKey) && "https://api.mistral.ai/v1/".equals(baseUrl)) {
                throw new ConfigValidationException(this.createApiKeyConfigProblem(configName));
            }
            final MistralAiStreamingChatModel.MistralAiStreamingChatModelBuilder builder = MistralAiStreamingChatModel.builder().baseUrl(baseUrl).apiKey(apiKey).modelName(chatModelConfig.modelName()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logRequests(), mistralAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logResponses(), mistralAiConfig.logResponses()})).timeout(mistralAiConfig.timeout().orElse(Duration.ofSeconds(10L)));
            if (chatModelConfig.temperature().isPresent()) {
                builder.temperature(Double.valueOf(chatModelConfig.temperature().getAsDouble()));
            }
            if (chatModelConfig.topP().isPresent()) {
                builder.topP(Double.valueOf(chatModelConfig.topP().getAsDouble()));
            }
            if (chatModelConfig.maxTokens().isPresent()) {
                builder.maxTokens(Integer.valueOf(chatModelConfig.maxTokens().getAsInt()));
            }
            if (chatModelConfig.safePrompt().isPresent()) {
                builder.safePrompt(chatModelConfig.safePrompt().get());
            }
            if (chatModelConfig.randomSeed().isPresent()) {
                builder.randomSeed(Integer.valueOf(chatModelConfig.randomSeed().getAsInt()));
            }
            return new Supplier<StreamingChatModel>(this){
                final /* synthetic */ MistralAiRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public StreamingChatModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<StreamingChatModel>(){

            @Override
            public StreamingChatModel get() {
                return new DisabledStreamingChatModel();
            }
        };
    }

    public Supplier<EmbeddingModel> embeddingModel(String configName) {
        LangChain4jMistralAiConfig.MistralAiConfig mistralAiConfig = this.correspondingMistralAiConfig(configName);
        if (mistralAiConfig.enableIntegration().booleanValue()) {
            EmbeddingModelConfig embeddingModelConfig = mistralAiConfig.embeddingModel();
            String apiKey = mistralAiConfig.apiKey();
            String baseUrl = mistralAiConfig.baseUrl();
            if ("dummy".equals(apiKey) && "https://api.mistral.ai/v1/".equals(baseUrl)) {
                throw new ConfigValidationException(this.createApiKeyConfigProblem(configName));
            }
            final MistralAiEmbeddingModel.MistralAiEmbeddingModelBuilder builder = MistralAiEmbeddingModel.builder().baseUrl(mistralAiConfig.baseUrl()).apiKey(apiKey).modelName(embeddingModelConfig.modelName()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{embeddingModelConfig.logRequests(), mistralAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{embeddingModelConfig.logResponses(), mistralAiConfig.logResponses()})).timeout(mistralAiConfig.timeout().orElse(Duration.ofSeconds(10L)));
            return new Supplier<EmbeddingModel>(this){
                final /* synthetic */ MistralAiRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public EmbeddingModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<EmbeddingModel>(){

            @Override
            public EmbeddingModel get() {
                return new DisabledEmbeddingModel();
            }
        };
    }

    public Supplier<ModerationModel> moderationModel(String configName) {
        LangChain4jMistralAiConfig.MistralAiConfig mistralAiConfig = this.correspondingMistralAiConfig(configName);
        if (mistralAiConfig.enableIntegration().booleanValue()) {
            ModerationModelConfig moderationModelConfig = mistralAiConfig.moderationModel();
            String apiKey = mistralAiConfig.apiKey();
            String baseUrl = mistralAiConfig.baseUrl();
            if ("dummy".equals(apiKey) && "https://api.mistral.ai/v1/".equals(baseUrl)) {
                throw new ConfigValidationException(this.createApiKeyConfigProblem(configName));
            }
            final MistralAiModerationModel.Builder builder = new MistralAiModerationModel.Builder().baseUrl(baseUrl).apiKey(apiKey).modelName(moderationModelConfig.modelName()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{moderationModelConfig.logRequests(), mistralAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{moderationModelConfig.logResponses(), mistralAiConfig.logResponses()})).timeout(mistralAiConfig.timeout().orElse(Duration.ofSeconds(10L)));
            return new Supplier<ModerationModel>(this){
                final /* synthetic */ MistralAiRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ModerationModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<ModerationModel>(){

            @Override
            public ModerationModel get() {
                return new DisabledModerationModel();
            }
        };
    }

    private LangChain4jMistralAiConfig.MistralAiConfig correspondingMistralAiConfig(String configName) {
        LangChain4jMistralAiConfig.MistralAiConfig config = NamedConfigUtil.isDefault((String)configName) ? ((LangChain4jMistralAiConfig)this.runtimeConfig.getValue()).defaultConfig() : ((LangChain4jMistralAiConfig)this.runtimeConfig.getValue()).namedConfig().get(configName);
        return config;
    }

    private ConfigValidationException.Problem[] createApiKeyConfigProblem(String configName) {
        return this.createConfigProblems("api-key", configName);
    }

    private ConfigValidationException.Problem[] createConfigProblems(String key, String configName) {
        return new ConfigValidationException.Problem[]{MistralAiRecorder.createConfigProblem(key, configName)};
    }

    private static ConfigValidationException.Problem createConfigProblem(String key, String configName) {
        return new ConfigValidationException.Problem(String.format("SRCFG00014: The config property quarkus.langchain4j.mistralai%s%s is required but it could not be found in any config source", NamedConfigUtil.isDefault((String)configName) ? "." : "." + configName + ".", key));
    }
}

