/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.ollama.deployment;

import io.quarkiverse.langchain4j.ModelName;
import io.quarkiverse.langchain4j.deployment.DotNames;
import io.quarkiverse.langchain4j.deployment.LangChain4jDotNames;
import io.quarkiverse.langchain4j.deployment.devservice.Langchain4jDevServicesEnabled;
import io.quarkiverse.langchain4j.deployment.items.ChatModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.DevServicesChatModelRequiredBuildItem;
import io.quarkiverse.langchain4j.deployment.items.DevServicesEmbeddingModelRequiredBuildItem;
import io.quarkiverse.langchain4j.deployment.items.EmbeddingModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedChatModelProviderBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedEmbeddingModelCandidateBuildItem;
import io.quarkiverse.langchain4j.ollama.deployment.LangChain4jOllamaOpenAiBuildConfig;
import io.quarkiverse.langchain4j.ollama.runtime.OllamaRecorder;
import io.quarkiverse.langchain4j.ollama.runtime.config.LangChain4jOllamaConfig;
import io.quarkiverse.langchain4j.ollama.runtime.config.LangChain4jOllamaFixedRuntimeConfig;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.runtime.configuration.ConfigUtils;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class OllamaProcessor {
    private static final String FEATURE = "langchain4j-ollama";
    private static final String PROVIDER = "ollama";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public void providerCandidates(BuildProducer<ChatModelProviderCandidateBuildItem> chatProducer, BuildProducer<EmbeddingModelProviderCandidateBuildItem> embeddingProducer, LangChain4jOllamaOpenAiBuildConfig config) {
        if (config.chatModel().enabled().isEmpty() || config.chatModel().enabled().get().booleanValue()) {
            chatProducer.produce((BuildItem)new ChatModelProviderCandidateBuildItem(PROVIDER));
        }
        if (config.embeddingModel().enabled().isEmpty() || config.embeddingModel().enabled().get().booleanValue()) {
            embeddingProducer.produce((BuildItem)new EmbeddingModelProviderCandidateBuildItem(PROVIDER));
        }
    }

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={Langchain4jDevServicesEnabled.class})
    public void devServicesSupport(List<SelectedChatModelProviderBuildItem> selectedChatModels, List<SelectedEmbeddingModelCandidateBuildItem> selectedEmbeddingModels, LangChain4jOllamaFixedRuntimeConfig fixedRuntimeConfig, BuildProducer<DevServicesChatModelRequiredBuildItem> chatProducer, BuildProducer<DevServicesEmbeddingModelRequiredBuildItem> embeddingProducer) {
        String modelId;
        String baseUrlProperty;
        String configName;
        for (SelectedChatModelProviderBuildItem selectedChatModelProviderBuildItem : selectedChatModels) {
            if (!PROVIDER.equals(selectedChatModelProviderBuildItem.getProvider())) continue;
            configName = selectedChatModelProviderBuildItem.getConfigName();
            baseUrlProperty = String.format("quarkus.langchain4j.ollama%s%s", NamedConfigUtil.isDefault((String)configName) ? "." : "." + configName + ".", "base-url");
            if (ConfigUtils.isPropertyPresent((String)baseUrlProperty)) continue;
            modelId = NamedConfigUtil.isDefault((String)configName) ? fixedRuntimeConfig.defaultConfig().chatModel().modelId() : ((LangChain4jOllamaFixedRuntimeConfig.OllamaConfig)fixedRuntimeConfig.namedConfig().get(configName)).chatModel().modelId();
            chatProducer.produce((BuildItem)new DevServicesChatModelRequiredBuildItem(PROVIDER, modelId, baseUrlProperty));
        }
        for (SelectedEmbeddingModelCandidateBuildItem selectedEmbeddingModelCandidateBuildItem : selectedEmbeddingModels) {
            if (!PROVIDER.equals(selectedEmbeddingModelCandidateBuildItem.getProvider())) continue;
            configName = selectedEmbeddingModelCandidateBuildItem.getConfigName();
            baseUrlProperty = String.format("quarkus.langchain4j.ollama%s%s", NamedConfigUtil.isDefault((String)configName) ? "." : "." + configName + ".", "base-url");
            if (ConfigUtils.isPropertyPresent((String)baseUrlProperty)) continue;
            modelId = NamedConfigUtil.isDefault((String)configName) ? fixedRuntimeConfig.defaultConfig().embeddingModel().modelId() : ((LangChain4jOllamaFixedRuntimeConfig.OllamaConfig)fixedRuntimeConfig.namedConfig().get(configName)).embeddingModel().modelId();
            embeddingProducer.produce((BuildItem)new DevServicesEmbeddingModelRequiredBuildItem(PROVIDER, modelId, baseUrlProperty));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void generateBeans(OllamaRecorder recorder, List<SelectedChatModelProviderBuildItem> selectedChatItem, List<SelectedEmbeddingModelCandidateBuildItem> selectedEmbedding, LangChain4jOllamaConfig config, LangChain4jOllamaFixedRuntimeConfig fixedRuntimeConfig, BuildProducer<SyntheticBeanBuildItem> beanProducer) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator builder;
        String configName;
        for (SelectedChatModelProviderBuildItem selectedChatModelProviderBuildItem : selectedChatItem) {
            if (!PROVIDER.equals(selectedChatModelProviderBuildItem.getProvider())) continue;
            configName = selectedChatModelProviderBuildItem.getConfigName();
            builder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)LangChain4jDotNames.CHAT_MODEL).setRuntimeInit().defaultBean()).scope(ApplicationScoped.class)).addInjectionPoint((Type)ParameterizedType.create((DotName)DotNames.CDI_INSTANCE, (Type[])new Type[]{ClassType.create((DotName)DotNames.CHAT_MODEL_LISTENER)}, null), new AnnotationInstance[0])).createWith(recorder.chatModel(config, fixedRuntimeConfig, configName));
            this.addQualifierIfNecessary(builder, configName);
            beanProducer.produce((BuildItem)builder.done());
            SyntheticBeanBuildItem.ExtendedBeanConfigurator streamingBuilder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)LangChain4jDotNames.STREAMING_CHAT_MODEL).setRuntimeInit().defaultBean()).scope(ApplicationScoped.class)).supplier(recorder.streamingChatModel(config, fixedRuntimeConfig, configName));
            this.addQualifierIfNecessary(streamingBuilder, configName);
            beanProducer.produce((BuildItem)streamingBuilder.done());
        }
        for (SelectedEmbeddingModelCandidateBuildItem selectedEmbeddingModelCandidateBuildItem : selectedEmbedding) {
            if (!PROVIDER.equals(selectedEmbeddingModelCandidateBuildItem.getProvider())) continue;
            configName = selectedEmbeddingModelCandidateBuildItem.getConfigName();
            builder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)LangChain4jDotNames.EMBEDDING_MODEL).setRuntimeInit().defaultBean()).unremovable()).scope(ApplicationScoped.class)).supplier(recorder.embeddingModel(config, fixedRuntimeConfig, configName));
            this.addQualifierIfNecessary(builder, configName);
            beanProducer.produce((BuildItem)builder.done());
        }
    }

    private void addQualifierIfNecessary(SyntheticBeanBuildItem.ExtendedBeanConfigurator builder, String configName) {
        if (!NamedConfigUtil.isDefault((String)configName)) {
            builder.addQualifier(AnnotationInstance.builder(ModelName.class).add("value", configName).build());
        }
    }
}

