/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.ollama;

import io.quarkiverse.langchain4j.ollama.Options;

public class CompletionRequest {
    private final String model;
    private final String prompt;
    private final Options options;
    private final Boolean stream;

    private CompletionRequest(Builder builder) {
        this.model = builder.model;
        this.prompt = builder.prompt;
        this.options = builder.options;
        this.stream = builder.stream;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getModel() {
        return this.model;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public Options getOptions() {
        return this.options;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public static final class Builder {
        private String model = "llama2";
        private String prompt;
        private Options options;
        private Boolean stream = false;

        private Builder() {
        }

        public Builder model(String val) {
            this.model = val;
            return this;
        }

        public Builder prompt(String val) {
            this.prompt = val;
            return this;
        }

        public Builder options(Options val) {
            this.options = val;
            return this;
        }

        public Builder stream(Boolean val) {
            this.stream = val;
            return this;
        }

        public CompletionRequest build() {
            return new CompletionRequest(this);
        }
    }
}

