/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.ollama;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.output.Response;
import io.quarkiverse.langchain4j.ollama.ChatRequest;
import io.quarkiverse.langchain4j.ollama.ChatResponse;
import io.quarkiverse.langchain4j.ollama.MessageMapper;
import io.quarkiverse.langchain4j.ollama.OllamaClient;
import io.quarkiverse.langchain4j.ollama.Options;
import io.smallrye.mutiny.Context;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class OllamaStreamingChatLanguageModel
implements StreamingChatLanguageModel {
    private final OllamaClient client;
    private final String model;
    private final String format;
    private final Options options;

    private OllamaStreamingChatLanguageModel(Builder builder) {
        this.client = new OllamaClient(builder.baseUrl, builder.timeout, builder.logRequests, builder.logResponses);
        this.model = builder.model;
        this.format = builder.format;
        this.options = builder.options;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void generate(List<ChatMessage> messages, final StreamingResponseHandler<AiMessage> handler) {
        ValidationUtils.ensureNotEmpty(messages, (String)"messages");
        ChatRequest request = ChatRequest.builder().model(this.model).messages(MessageMapper.toOllamaMessages(messages)).options(this.options).format(this.format).stream(true).build();
        final Context context = Context.of((Object[])new Object[]{"response", new ArrayList()});
        this.client.streamingChat(request).subscribe().with(context, (Consumer)new Consumer<ChatResponse>(){

            @Override
            public void accept(ChatResponse response) {
                try {
                    if (response == null || response.message() == null || response.message().content() == null || response.message().content().isBlank()) {
                        return;
                    }
                    ((List)context.get("response")).add(response);
                    handler.onNext(response.message().content());
                }
                catch (Exception e) {
                    handler.onError((Throwable)e);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable error) {
                handler.onError(error);
            }
        }, new Runnable(){

            @Override
            public void run() {
                List list = (List)context.get("response");
                StringBuilder builder = new StringBuilder();
                for (ChatResponse response : list) {
                    builder.append(response.message().content());
                }
                AiMessage message = new AiMessage(builder.toString());
                handler.onComplete(Response.from((Object)message));
            }
        });
    }

    public static final class Builder {
        private String baseUrl = "http://localhost:11434";
        private Duration timeout = Duration.ofSeconds(10L);
        private String model;
        private String format;
        private Options options;
        private boolean logRequests = false;
        private boolean logResponses = false;

        private Builder() {
        }

        public Builder baseUrl(String val) {
            this.baseUrl = val;
            return this;
        }

        public Builder timeout(Duration val) {
            this.timeout = val;
            return this;
        }

        public Builder model(String val) {
            this.model = val;
            return this;
        }

        public Builder format(String val) {
            this.format = val;
            return this;
        }

        public Builder options(Options val) {
            this.options = val;
            return this;
        }

        public Builder logRequests(boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public Builder logResponses(boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public OllamaStreamingChatLanguageModel build() {
            return new OllamaStreamingChatLanguageModel(this);
        }
    }
}

