/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.ollama;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ContentType;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElementHelper;
import io.quarkiverse.langchain4j.QuarkusJsonCodecFactory;
import io.quarkiverse.langchain4j.ollama.ImageUtils;
import io.quarkiverse.langchain4j.ollama.Message;
import io.quarkiverse.langchain4j.ollama.Role;
import io.quarkiverse.langchain4j.ollama.Tool;
import io.quarkiverse.langchain4j.ollama.ToolCall;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

final class MessageMapper {
    private static final Predicate<UserMessage> hasImages;

    private MessageMapper() {
    }

    static List<Message> toOllamaMessages(List<ChatMessage> messages) {
        ArrayList<Message> result = new ArrayList<Message>(messages.size());
        for (ChatMessage chatMessage : messages) {
            UserMessage userMessage;
            if (chatMessage instanceof UserMessage && hasImages.test(userMessage = (UserMessage)chatMessage)) {
                result.add(MessageMapper.messagesWithImageSupport(userMessage));
                continue;
            }
            result.add(MessageMapper.otherMessages(chatMessage));
        }
        return result;
    }

    private static Message messagesWithImageSupport(UserMessage userMessage) {
        Map<ContentType, List<Content>> groupedContents = userMessage.contents().stream().collect(Collectors.groupingBy(Content::type));
        if (groupedContents.get(ContentType.TEXT).size() != 1) {
            throw new RuntimeException("Expecting single text content, but got: " + String.valueOf(userMessage.contents()));
        }
        String text = ((TextContent)groupedContents.get(ContentType.TEXT).get(0)).text();
        List<ImageContent> imageContents = groupedContents.get(ContentType.IMAGE).stream().map(content -> (ImageContent)content).collect(Collectors.toList());
        return Message.builder().role(MessageMapper.toOllamaRole(userMessage.type())).content(text).images(ImageUtils.base64EncodeImageList(imageContents)).build();
    }

    private static Message otherMessages(ChatMessage message) {
        if (message instanceof AiMessage) {
            AiMessage aiMessage = (AiMessage)message;
            if (!aiMessage.hasToolExecutionRequests()) {
                return Message.builder().role(MessageMapper.toOllamaRole(ChatMessageType.AI)).content(aiMessage.text()).build();
            }
            try {
                List toolExecutionRequests = aiMessage.toolExecutionRequests();
                ArrayList<ToolCall> toolCalls = new ArrayList<ToolCall>(toolExecutionRequests.size());
                for (ToolExecutionRequest toolExecutionRequest : toolExecutionRequests) {
                    String argumentsStr = toolExecutionRequest.arguments();
                    String name = toolExecutionRequest.name();
                    Map arguments = (Map)QuarkusJsonCodecFactory.ObjectMapperHolder.MAPPER.readValue(argumentsStr, Map.class);
                    toolCalls.add(ToolCall.fromFunctionCall(name, arguments));
                }
                return Message.builder().role(MessageMapper.toOllamaRole(ChatMessageType.AI)).toolCalls(toolCalls).build();
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException("Unable to perform conversion of tool response", e);
            }
        }
        if (message instanceof ToolExecutionResultMessage) {
            return Message.builder().role(MessageMapper.toOllamaRole(ChatMessageType.TOOL_EXECUTION_RESULT)).content(message.text()).build();
        }
        return Message.builder().role(MessageMapper.toOllamaRole(message.type())).content(message.text()).build();
    }

    private static Role toOllamaRole(ChatMessageType chatMessageType) {
        return switch (chatMessageType) {
            default -> throw new IncompatibleClassChangeError();
            case ChatMessageType.SYSTEM -> Role.SYSTEM;
            case ChatMessageType.USER -> Role.USER;
            case ChatMessageType.AI -> Role.ASSISTANT;
            case ChatMessageType.TOOL_EXECUTION_RESULT -> Role.TOOL;
        };
    }

    static List<Tool> toTools(Collection<ToolSpecification> toolSpecifications) {
        if (toolSpecifications.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Tool> result = new ArrayList<Tool>(toolSpecifications.size());
        for (ToolSpecification toolSpecification : toolSpecifications) {
            result.add(MessageMapper.toTool(toolSpecification));
        }
        return result;
    }

    private static Tool toTool(ToolSpecification toolSpecification) {
        Tool.Function.Parameters functionParameters = MessageMapper.toFunctionParameters(toolSpecification.parameters());
        return new Tool(Tool.Type.FUNCTION, new Tool.Function(toolSpecification.name(), toolSpecification.description(), functionParameters));
    }

    private static Tool.Function.Parameters toFunctionParameters(JsonObjectSchema parameters) {
        if (parameters == null) {
            return Tool.Function.Parameters.empty();
        }
        return Tool.Function.Parameters.objectType(JsonSchemaElementHelper.toMap((Map)parameters.properties()), parameters.required());
    }

    static {
        new TypeReference<Object>(){};
        hasImages = userMessage -> userMessage.contents().stream().anyMatch(content -> ContentType.IMAGE.equals((Object)content.type()));
    }
}

