/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.ollama;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponse;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import io.quarkiverse.langchain4j.ollama.ChatRequest;
import io.quarkiverse.langchain4j.ollama.ChatResponse;
import io.quarkiverse.langchain4j.ollama.Message;
import io.quarkiverse.langchain4j.ollama.MessageMapper;
import io.quarkiverse.langchain4j.ollama.OllamaClient;
import io.quarkiverse.langchain4j.ollama.Options;
import io.quarkiverse.langchain4j.ollama.Tool;
import io.quarkiverse.langchain4j.ollama.ToolCall;
import io.smallrye.mutiny.Context;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class OllamaStreamingChatLanguageModel
implements StreamingChatLanguageModel {
    private static final Logger log = Logger.getLogger(OllamaStreamingChatLanguageModel.class);
    private static final String TOOLS_CONTEXT = "TOOLS";
    private static final String TOKEN_USAGE_CONTEXT = "TOKEN_USAGE";
    private static final String RESPONSE_CONTEXT = "RESPONSE";
    private static final String MODEL_ID = "MODEL_ID";
    private final OllamaClient client;
    private final String model;
    private final String format;
    private final Options options;
    private final List<ChatModelListener> listeners;

    private OllamaStreamingChatLanguageModel(Builder builder) {
        this.client = new OllamaClient(builder.baseUrl, builder.timeout, builder.logRequests, builder.logResponses, builder.configName, builder.tlsConfigurationName);
        this.model = builder.model;
        this.format = builder.format;
        this.options = builder.options;
        this.listeners = builder.listeners;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, final StreamingResponseHandler<AiMessage> handler) {
        ValidationUtils.ensureNotEmpty(messages, (String)"messages");
        List<Tool> tools = toolSpecifications != null && toolSpecifications.size() > 0 ? MessageMapper.toTools(toolSpecifications) : null;
        ChatRequest request = ChatRequest.builder().model(this.model).messages(MessageMapper.toOllamaMessages(messages)).options(this.options).format(this.format).tools(tools).stream(true).build();
        final Context context = Context.empty();
        context.put(MODEL_ID, (Object)"");
        context.put(RESPONSE_CONTEXT, new ArrayList());
        context.put(TOOLS_CONTEXT, new ArrayList());
        final ChatModelRequest modelListenerRequest = this.createModelListenerRequest(request, messages, toolSpecifications);
        final ConcurrentHashMap attributes = new ConcurrentHashMap();
        ChatModelRequestContext requestContext = new ChatModelRequestContext(modelListenerRequest, attributes);
        this.listeners.forEach(listener -> {
            try {
                listener.onRequest(requestContext);
            }
            catch (Exception e) {
                log.warn((Object)"Exception while calling model listener", (Throwable)e);
            }
        });
        this.client.streamingChat(request).subscribe().with(context, (Consumer)new Consumer<ChatResponse>(this){
            final /* synthetic */ OllamaStreamingChatLanguageModel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(ChatResponse response) {
                try {
                    if (response == null || response.message() == null) {
                        return;
                    }
                    if (response.message().toolCalls() != null) {
                        List toolContext = (List)context.get(OllamaStreamingChatLanguageModel.TOOLS_CONTEXT);
                        List<ToolCall> toolCalls = response.message().toolCalls();
                        toolCalls.stream().map(ToolCall::toToolExecutionRequest).forEach(toolContext::add);
                    }
                    if (!response.message().content().isEmpty()) {
                        ((List)context.get(OllamaStreamingChatLanguageModel.RESPONSE_CONTEXT)).add(response);
                        handler.onNext(response.message().content());
                    }
                    if (response.done().booleanValue()) {
                        if (response.model() != null) {
                            context.put(OllamaStreamingChatLanguageModel.MODEL_ID, (Object)response.model());
                        }
                        if (response.evalCount() != null && response.promptEvalCount() != null) {
                            TokenUsage tokenUsage = new TokenUsage(response.promptEvalCount(), response.evalCount(), Integer.valueOf(response.evalCount() + response.promptEvalCount()));
                            context.put(OllamaStreamingChatLanguageModel.TOKEN_USAGE_CONTEXT, (Object)tokenUsage);
                        }
                    }
                }
                catch (Exception e) {
                    handler.onError((Throwable)e);
                }
            }
        }, (Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ OllamaStreamingChatLanguageModel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(Throwable error) {
                List chatResponses = (List)context.get(OllamaStreamingChatLanguageModel.RESPONSE_CONTEXT);
                String stringResponse = chatResponses.stream().map(ChatResponse::message).map(Message::content).collect(Collectors.joining());
                AiMessage aiMessage = new AiMessage(stringResponse);
                Response aiMessageResponse = Response.from((Object)aiMessage);
                ChatModelResponse modelListenerPartialResponse = this.this$0.createModelListenerResponse(null, (String)context.get(OllamaStreamingChatLanguageModel.MODEL_ID), (Response<AiMessage>)aiMessageResponse);
                ChatModelErrorContext errorContext = new ChatModelErrorContext(error, modelListenerRequest, modelListenerPartialResponse, attributes);
                this.this$0.listeners.forEach(listener -> {
                    try {
                        listener.onError(errorContext);
                    }
                    catch (Exception e) {
                        log.warn((Object)"Exception while calling model listener", (Throwable)e);
                    }
                });
                handler.onError(error);
            }
        }, new Runnable(){
            final /* synthetic */ OllamaStreamingChatLanguageModel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                TokenUsage tokenUsage = context.contains(OllamaStreamingChatLanguageModel.TOKEN_USAGE_CONTEXT) ? (TokenUsage)context.get(OllamaStreamingChatLanguageModel.TOKEN_USAGE_CONTEXT) : null;
                List chatResponses = (List)context.get(OllamaStreamingChatLanguageModel.RESPONSE_CONTEXT);
                List toolExecutionRequests = (List)context.get(OllamaStreamingChatLanguageModel.TOOLS_CONTEXT);
                if (!toolExecutionRequests.isEmpty()) {
                    handler.onComplete(Response.from((Object)AiMessage.from((List)toolExecutionRequests), (TokenUsage)tokenUsage));
                    return;
                }
                String stringResponse = chatResponses.stream().map(ChatResponse::message).map(Message::content).collect(Collectors.joining());
                AiMessage aiMessage = new AiMessage(stringResponse);
                Response aiMessageResponse = Response.from((Object)aiMessage, (TokenUsage)tokenUsage);
                ChatModelResponse modelListenerResponse = this.this$0.createModelListenerResponse(null, (String)context.get(OllamaStreamingChatLanguageModel.MODEL_ID), (Response<AiMessage>)aiMessageResponse);
                ChatModelResponseContext responseContext = new ChatModelResponseContext(modelListenerResponse, modelListenerRequest, attributes);
                this.this$0.listeners.forEach(listener -> {
                    try {
                        listener.onResponse(responseContext);
                    }
                    catch (Exception e) {
                        log.warn((Object)"Exception while calling model listener", (Throwable)e);
                    }
                });
                handler.onComplete(aiMessageResponse);
            }
        });
    }

    private ChatModelRequest createModelListenerRequest(ChatRequest request, List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        Options options = request.options();
        ChatModelRequest.ChatModelRequestBuilder builder = ChatModelRequest.builder().model(request.model()).messages(messages).toolSpecifications(toolSpecifications);
        if (options != null) {
            builder.temperature(options.temperature()).topP(options.topP()).maxTokens(options.numPredict());
        }
        return builder.build();
    }

    private ChatModelResponse createModelListenerResponse(String responseId, String responseModel, Response<AiMessage> response) {
        if (response == null) {
            return null;
        }
        return ChatModelResponse.builder().id(responseId).model(responseModel).tokenUsage(response.tokenUsage()).finishReason(response.finishReason()).aiMessage((AiMessage)response.content()).build();
    }

    public void generate(List<ChatMessage> messages, ToolSpecification toolSpecification, StreamingResponseHandler<AiMessage> handler) {
        this.generate(messages, List.of(toolSpecification), handler);
    }

    public void generate(List<ChatMessage> messages, StreamingResponseHandler<AiMessage> handler) {
        this.generate(messages, List.of(), handler);
    }

    public static final class Builder {
        private String baseUrl = "http://localhost:11434";
        private String tlsConfigurationName;
        private Duration timeout = Duration.ofSeconds(10L);
        private String model;
        private String format;
        private Options options;
        private boolean logRequests = false;
        private boolean logResponses = false;
        private String configName;
        private List<ChatModelListener> listeners = Collections.emptyList();

        private Builder() {
        }

        public Builder baseUrl(String val) {
            this.baseUrl = val;
            return this;
        }

        public Builder tlsConfigurationName(String tlsConfigurationName) {
            this.tlsConfigurationName = tlsConfigurationName;
            return this;
        }

        public Builder timeout(Duration val) {
            this.timeout = val;
            return this;
        }

        public Builder model(String val) {
            this.model = val;
            return this;
        }

        public Builder format(String val) {
            this.format = val;
            return this;
        }

        public Builder options(Options val) {
            this.options = val;
            return this;
        }

        public Builder logRequests(boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public Builder logResponses(boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public Builder configName(String configName) {
            this.configName = configName;
            return this;
        }

        public Builder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public OllamaStreamingChatLanguageModel build() {
            return new OllamaStreamingChatLanguageModel(this);
        }
    }
}

