/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.ollama;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import io.quarkiverse.langchain4j.QuarkusJsonCodecFactory;
import io.quarkiverse.langchain4j.ollama.ChatRequest;
import io.quarkiverse.langchain4j.ollama.ChatResponse;
import io.quarkiverse.langchain4j.ollama.EmbeddingRequest;
import io.quarkiverse.langchain4j.ollama.EmbeddingResponse;
import io.quarkus.rest.client.reactive.jackson.ClientObjectMapper;
import io.smallrye.mutiny.Multi;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.rest.client.annotation.RegisterProvider;
import org.eclipse.microprofile.rest.client.annotation.RegisterProviders;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.ClientWebApplicationException;
import org.jboss.resteasy.reactive.RestStreamElementType;
import org.jboss.resteasy.reactive.client.api.ClientLogger;

@Path(value="")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@RegisterProviders(value={@RegisterProvider(value=OllamaRestApiReaderInterceptor.class), @RegisterProvider(value=OpenAiRestApiWriterInterceptor.class)})
public interface OllamaRestApi {
    @Path(value="/api/chat")
    @POST
    public ChatResponse chat(ChatRequest var1);

    @Path(value="/api/chat")
    @POST
    @RestStreamElementType(value="application/json")
    public Multi<ChatResponse> streamingChat(ChatRequest var1);

    @Path(value="/api/embeddings")
    @POST
    public EmbeddingResponse embeddings(EmbeddingRequest var1);

    @ClientObjectMapper
    public static ObjectMapper objectMapper(ObjectMapper defaultObjectMapper) {
        return QuarkusJsonCodecFactory.SnakeCaseObjectMapperHolder.MAPPER;
    }

    public static class OllamaLogger
    implements ClientLogger {
        private static final Logger log = Logger.getLogger(OllamaLogger.class);
        private final boolean logRequests;
        private final boolean logResponses;

        public OllamaLogger(boolean logRequests, boolean logResponses) {
            this.logRequests = logRequests;
            this.logResponses = logResponses;
        }

        public void setBodySize(int bodySize) {
        }

        public void logRequest(HttpClientRequest request, Buffer body, boolean omitBody) {
            if (!this.logRequests || !log.isInfoEnabled()) {
                return;
            }
            try {
                log.infof("Request:\n- method: %s\n- url: %s\n- headers: %s\n- body: %s", new Object[]{request.getMethod(), request.absoluteURI(), this.inOneLine(request.headers()), this.bodyToString(body)});
            }
            catch (Exception e) {
                log.warn((Object)"Failed to log request", (Throwable)e);
            }
        }

        public void logResponse(final HttpClientResponse response, boolean redirect) {
            if (!this.logResponses || !log.isInfoEnabled()) {
                return;
            }
            response.bodyHandler((Handler)new Handler<Buffer>(this){
                final /* synthetic */ OllamaLogger this$0;
                {
                    this.this$0 = this$0;
                }

                public void handle(Buffer body) {
                    try {
                        log.infof("Response:\n- status code: %s\n- headers: %s\n- body: %s", (Object)response.statusCode(), (Object)this.this$0.inOneLine(response.headers()), (Object)this.this$0.bodyToString(body));
                    }
                    catch (Exception e) {
                        log.warn((Object)"Failed to log response", (Throwable)e);
                    }
                }
            });
        }

        private String bodyToString(Buffer body) {
            if (body == null) {
                return "";
            }
            String rawBody = body.toString();
            try {
                return QuarkusJsonCodecFactory.SnakeCaseObjectMapperHolder.MAPPER.readTree(rawBody).toPrettyString();
            }
            catch (JsonProcessingException ignored) {
                return rawBody;
            }
        }

        private String inOneLine(MultiMap headers) {
            return StreamSupport.stream(headers.spliterator(), false).map(header -> {
                String headerKey = (String)header.getKey();
                String headerValue = (String)header.getValue();
                return String.format("[%s: %s]", headerKey, headerValue);
            }).collect(Collectors.joining(", "));
        }
    }

    public static class OpenAiRestApiWriterInterceptor
    implements WriterInterceptor {
        public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
            Object entity = context.getEntity();
            if (entity instanceof ChatRequest) {
                ChatRequest request = (ChatRequest)entity;
                MultivaluedMap headers = context.getHeaders();
                List acceptList = (List)headers.get((Object)"Accept");
                if (acceptList != null && acceptList.size() == 1) {
                    String accept = (String)acceptList.get(0);
                    if ("application/json".equals(accept)) {
                        if (Boolean.TRUE.equals(request.stream())) {
                            context.setEntity((Object)ChatRequest.builder().from(request).stream(null).build());
                        }
                    } else if ("text/event-stream".equals(accept) && !Boolean.TRUE.equals(request.stream())) {
                        context.setEntity((Object)ChatRequest.builder().from(request).stream(true).build());
                    }
                }
            }
            context.proceed();
        }
    }

    public static class OllamaRestApiReaderInterceptor
    implements ReaderInterceptor {
        public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
            try {
                return context.proceed();
            }
            catch (ProcessingException | ClientWebApplicationException e) {
                InputStream is;
                Object invokedMethod;
                WebApplicationException wae;
                ProcessingException pe;
                if ((e instanceof ProcessingException && (pe = (ProcessingException)e).getCause() instanceof MismatchedInputException || e instanceof WebApplicationException && ((wae = (WebApplicationException)e).getCause() instanceof JsonParseException && wae.getResponse().getStatus() == 200 || wae.getCause() instanceof MismatchedInputException && wae.getResponse().getStatus() == 400)) && (invokedMethod = context.getProperty("org.eclipse.microprofile.rest.client.invokedMethod")) != null && invokedMethod.toString().contains("OllamaRestApi.streamingChat") && (is = context.getInputStream()) instanceof ByteArrayInputStream) {
                    ByteArrayInputStream bis = (ByteArrayInputStream)is;
                    bis.reset();
                    String chunk = new String(bis.readAllBytes());
                    Context ctx = Vertx.currentContext();
                    if (ctx == null) {
                        throw e;
                    }
                    String existingBuffer = (String)ctx.getLocal((Object)"buffer");
                    if (existingBuffer != null && !existingBuffer.isEmpty()) {
                        if (chunk.endsWith("}")) {
                            ctx.putLocal((Object)"buffer", (Object)"");
                            String entireLine = existingBuffer + chunk;
                            return QuarkusJsonCodecFactory.SnakeCaseObjectMapperHolder.MAPPER.readValue(entireLine, ChatResponse.class);
                        }
                        ctx.putLocal((Object)"buffer", (Object)(existingBuffer + chunk));
                        return ChatResponse.emptyNotDone();
                    }
                    ctx.putLocal((Object)"buffer", (Object)chunk);
                    return ChatResponse.emptyNotDone();
                }
                throw e;
            }
        }
    }
}

