/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.ollama.runtime;

import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.DisabledChatModel;
import dev.langchain4j.model.chat.DisabledStreamingChatModel;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.embedding.DisabledEmbeddingModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.ollama.OllamaChatModel;
import io.quarkiverse.langchain4j.auth.ModelAuthProvider;
import io.quarkiverse.langchain4j.jaxrsclient.JaxRsHttpClientBuilder;
import io.quarkiverse.langchain4j.ollama.OllamaEmbeddingModel;
import io.quarkiverse.langchain4j.ollama.OllamaModelAuthProviderFilter;
import io.quarkiverse.langchain4j.ollama.OllamaStreamingChatLanguageModel;
import io.quarkiverse.langchain4j.ollama.Options;
import io.quarkiverse.langchain4j.ollama.runtime.config.ChatModelConfig;
import io.quarkiverse.langchain4j.ollama.runtime.config.EmbeddingModelConfig;
import io.quarkiverse.langchain4j.ollama.runtime.config.LangChain4jOllamaConfig;
import io.quarkiverse.langchain4j.ollama.runtime.config.LangChain4jOllamaFixedRuntimeConfig;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkiverse.langchain4j.runtime.OptionalUtil;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.TlsConfigurationRegistry;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@Recorder
public class OllamaRecorder {
    private static final String DEFAULT_BASE_URL = "http://localhost:11434";
    private static final TypeLiteral<Instance<ChatModelListener>> CHAT_MODEL_LISTENER_TYPE_LITERAL = new TypeLiteral<Instance<ChatModelListener>>(){};

    public Function<SyntheticCreationalContext<ChatModel>, ChatModel> chatModel(LangChain4jOllamaConfig runtimeConfig, LangChain4jOllamaFixedRuntimeConfig fixedRuntimeConfig, final String configName) {
        final LangChain4jOllamaConfig.OllamaConfig ollamaConfig = this.correspondingOllamaConfig(runtimeConfig, configName);
        LangChain4jOllamaFixedRuntimeConfig.OllamaConfig ollamaFixedConfig = this.correspondingOllamaFixedConfig(fixedRuntimeConfig, configName);
        if (ollamaConfig.enableIntegration().booleanValue()) {
            ChatModelConfig chatModelConfig = ollamaConfig.chatModel();
            final JaxRsHttpClientBuilder httpClientBuilder = new JaxRsHttpClientBuilder();
            final OllamaChatModel.OllamaChatModelBuilder ollamaChatModelBuilder = OllamaChatModel.builder().httpClientBuilder((HttpClientBuilder)httpClientBuilder).baseUrl(ollamaConfig.baseUrl().orElse(DEFAULT_BASE_URL)).timeout(ollamaConfig.timeout().orElse(Duration.ofSeconds(10L))).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logRequests(), ollamaConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logResponses(), ollamaConfig.logResponses()})).modelName(ollamaFixedConfig.chatModel().modelId()).format((String)chatModelConfig.format().orElse(null)).temperature(chatModelConfig.temperature()).topK(chatModelConfig.topK()).topP(chatModelConfig.topP());
            if (chatModelConfig.numPredict().isPresent()) {
                ollamaChatModelBuilder.numPredict(Integer.valueOf(chatModelConfig.numPredict().getAsInt()));
            }
            if (chatModelConfig.stop().isPresent()) {
                ollamaChatModelBuilder.stop(chatModelConfig.stop().get());
            }
            if (chatModelConfig.seed().isPresent()) {
                ollamaChatModelBuilder.seed(chatModelConfig.seed().get());
            }
            if (chatModelConfig.format().isEmpty() || !"json".equals(chatModelConfig.format().get())) {
                ollamaChatModelBuilder.supportedCapabilities(new Capability[]{Capability.RESPONSE_FORMAT_JSON_SCHEMA});
            }
            return new Function<SyntheticCreationalContext<ChatModel>, ChatModel>(this){
                final /* synthetic */ OllamaRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ChatModel apply(SyntheticCreationalContext<ChatModel> context) {
                    Optional maybeTlsConfiguration;
                    Instance tlsConfigurationRegistry;
                    ollamaChatModelBuilder.listeners(((Instance)context.getInjectedReference(CHAT_MODEL_LISTENER_TYPE_LITERAL, new Annotation[0])).stream().collect(Collectors.toList()));
                    Optional maybeModelAuthProvider = ModelAuthProvider.resolve((String)(NamedConfigUtil.isDefault((String)configName) ? null : configName));
                    if (maybeModelAuthProvider.isPresent()) {
                        httpClientBuilder.addClientProvider((Object)new OllamaModelAuthProviderFilter((ModelAuthProvider)maybeModelAuthProvider.get()));
                    }
                    if ((tlsConfigurationRegistry = CDI.current().select(TlsConfigurationRegistry.class, new Annotation[0])).isResolvable() && (maybeTlsConfiguration = TlsConfiguration.from((TlsConfigurationRegistry)((TlsConfigurationRegistry)tlsConfigurationRegistry.get()), ollamaConfig.tlsConfigurationName())).isPresent()) {
                        httpClientBuilder.tlsConfiguration((TlsConfiguration)maybeTlsConfiguration.get());
                    }
                    return ollamaChatModelBuilder.build();
                }
            };
        }
        return new Function<SyntheticCreationalContext<ChatModel>, ChatModel>(){

            @Override
            public ChatModel apply(SyntheticCreationalContext<ChatModel> context) {
                return new DisabledChatModel();
            }
        };
    }

    public Supplier<EmbeddingModel> embeddingModel(LangChain4jOllamaConfig runtimeConfig, LangChain4jOllamaFixedRuntimeConfig fixedRuntimeConfig, String configName) {
        LangChain4jOllamaConfig.OllamaConfig ollamaConfig = this.correspondingOllamaConfig(runtimeConfig, configName);
        LangChain4jOllamaFixedRuntimeConfig.OllamaConfig ollamaFixedConfig = this.correspondingOllamaFixedConfig(fixedRuntimeConfig, configName);
        if (ollamaConfig.enableIntegration().booleanValue()) {
            EmbeddingModelConfig embeddingModelConfig = ollamaConfig.embeddingModel();
            Options.Builder optionsBuilder = Options.builder().temperature(embeddingModelConfig.temperature()).topK(embeddingModelConfig.topK()).topP(embeddingModelConfig.topP()).numPredict(embeddingModelConfig.numPredict());
            if (embeddingModelConfig.stop().isPresent()) {
                optionsBuilder.stop(embeddingModelConfig.stop().get());
            }
            final OllamaEmbeddingModel.Builder builder = OllamaEmbeddingModel.builder().baseUrl(ollamaConfig.baseUrl().orElse(DEFAULT_BASE_URL)).tlsConfigurationName(ollamaConfig.tlsConfigurationName().orElse(null)).timeout(ollamaConfig.timeout().orElse(Duration.ofSeconds(10L))).model(ollamaFixedConfig.embeddingModel().modelId()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{embeddingModelConfig.logRequests(), ollamaConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{embeddingModelConfig.logResponses(), ollamaConfig.logResponses()})).configName(NamedConfigUtil.isDefault((String)configName) ? null : configName);
            return new Supplier<EmbeddingModel>(this){
                final /* synthetic */ OllamaRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public EmbeddingModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<EmbeddingModel>(){

            @Override
            public EmbeddingModel get() {
                return new DisabledEmbeddingModel();
            }
        };
    }

    public Function<SyntheticCreationalContext<StreamingChatModel>, StreamingChatModel> streamingChatModel(LangChain4jOllamaConfig runtimeConfig, LangChain4jOllamaFixedRuntimeConfig fixedRuntimeConfig, String configName) {
        LangChain4jOllamaConfig.OllamaConfig ollamaConfig = this.correspondingOllamaConfig(runtimeConfig, configName);
        LangChain4jOllamaFixedRuntimeConfig.OllamaConfig ollamaFixedConfig = this.correspondingOllamaFixedConfig(fixedRuntimeConfig, configName);
        if (ollamaConfig.enableIntegration().booleanValue()) {
            ChatModelConfig chatModelConfig = ollamaConfig.chatModel();
            Options.Builder optionsBuilder = Options.builder().temperature(chatModelConfig.temperature()).topK(chatModelConfig.topK()).topP(chatModelConfig.topP());
            if (chatModelConfig.numPredict().isPresent()) {
                optionsBuilder.numPredict(chatModelConfig.numPredict().getAsInt());
            }
            if (chatModelConfig.stop().isPresent()) {
                optionsBuilder.stop(chatModelConfig.stop().get());
            }
            if (chatModelConfig.seed().isPresent()) {
                optionsBuilder.seed(chatModelConfig.seed().get());
            }
            final OllamaStreamingChatLanguageModel.Builder builder = OllamaStreamingChatLanguageModel.builder().baseUrl(ollamaConfig.baseUrl().orElse(DEFAULT_BASE_URL)).tlsConfigurationName(ollamaConfig.tlsConfigurationName().orElse(null)).timeout(ollamaConfig.timeout().orElse(Duration.ofSeconds(10L))).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logRequests(), ollamaConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logResponses(), ollamaConfig.logResponses()})).model(ollamaFixedConfig.chatModel().modelId()).options(optionsBuilder.build()).configName(NamedConfigUtil.isDefault((String)configName) ? null : configName);
            return new Function<SyntheticCreationalContext<StreamingChatModel>, StreamingChatModel>(this){
                final /* synthetic */ OllamaRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public StreamingChatModel apply(SyntheticCreationalContext<StreamingChatModel> context) {
                    builder.listeners(((Instance)context.getInjectedReference(CHAT_MODEL_LISTENER_TYPE_LITERAL, new Annotation[0])).stream().collect(Collectors.toList()));
                    return builder.build();
                }
            };
        }
        return new Function<SyntheticCreationalContext<StreamingChatModel>, StreamingChatModel>(){

            @Override
            public StreamingChatModel apply(SyntheticCreationalContext<StreamingChatModel> context) {
                return new DisabledStreamingChatModel();
            }
        };
    }

    private LangChain4jOllamaConfig.OllamaConfig correspondingOllamaConfig(LangChain4jOllamaConfig runtimeConfig, String configName) {
        LangChain4jOllamaConfig.OllamaConfig ollamaConfig = NamedConfigUtil.isDefault((String)configName) ? runtimeConfig.defaultConfig() : runtimeConfig.namedConfig().get(configName);
        return ollamaConfig;
    }

    private LangChain4jOllamaFixedRuntimeConfig.OllamaConfig correspondingOllamaFixedConfig(LangChain4jOllamaFixedRuntimeConfig runtimeConfig, String configName) {
        LangChain4jOllamaFixedRuntimeConfig.OllamaConfig ollamaConfig = NamedConfigUtil.isDefault((String)configName) ? runtimeConfig.defaultConfig() : runtimeConfig.namedConfig().get(configName);
        return ollamaConfig;
    }
}

