/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.ollama;

import io.quarkiverse.langchain4j.ollama.CompletionRequest;
import io.quarkiverse.langchain4j.ollama.CompletionResponse;
import io.quarkiverse.langchain4j.ollama.EmbeddingRequest;
import io.quarkiverse.langchain4j.ollama.EmbeddingResponse;
import io.quarkiverse.langchain4j.ollama.OllamaRestApi;
import io.quarkus.rest.client.reactive.QuarkusRestClientBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.api.LoggingScope;

public class OllamaClient {
    private final OllamaRestApi restApi;

    public OllamaClient(String baseUrl, Duration timeout, boolean logRequests, boolean logResponses) {
        try {
            QuarkusRestClientBuilder builder = QuarkusRestClientBuilder.newBuilder().baseUri(new URI(baseUrl)).connectTimeout(timeout.toSeconds(), TimeUnit.SECONDS).readTimeout(timeout.toSeconds(), TimeUnit.SECONDS);
            if (logRequests || logResponses) {
                builder.loggingScope(LoggingScope.REQUEST_RESPONSE);
                builder.clientLogger((ClientLogger)new OllamaRestApi.OllamaLogger(logRequests, logResponses));
            }
            this.restApi = (OllamaRestApi)builder.build(OllamaRestApi.class);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletionResponse completion(CompletionRequest request) {
        return this.restApi.generate(request);
    }

    public EmbeddingResponse embedding(EmbeddingRequest request) {
        return this.restApi.embeddings(request);
    }
}

