/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.ollama;

import io.quarkiverse.langchain4j.auth.ModelAuthProvider;
import io.quarkiverse.langchain4j.ollama.ChatRequest;
import io.quarkiverse.langchain4j.ollama.ChatResponse;
import io.quarkiverse.langchain4j.ollama.EmbeddingRequest;
import io.quarkiverse.langchain4j.ollama.EmbeddingResponse;
import io.quarkiverse.langchain4j.ollama.OllamaModelAuthProviderFilter;
import io.quarkiverse.langchain4j.ollama.OllamaRestApi;
import io.quarkus.rest.client.reactive.QuarkusRestClientBuilder;
import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.smallrye.mutiny.Multi;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.api.LoggingScope;

public class OllamaClient {
    private final OllamaRestApi restApi;

    public OllamaClient(String baseUrl, Duration timeout, boolean logRequests, boolean logResponses, String configName, String tlsConfigurationName) {
        try {
            Instance tlsConfigurationRegistry;
            Optional maybeModelAuthProvider;
            QuarkusRestClientBuilder builder = QuarkusRestClientBuilder.newBuilder().baseUri(new URI(baseUrl)).connectTimeout(timeout.toSeconds(), TimeUnit.SECONDS).readTimeout(timeout.toSeconds(), TimeUnit.SECONDS);
            if (logRequests || logResponses) {
                builder.loggingScope(LoggingScope.REQUEST_RESPONSE);
                builder.clientLogger((ClientLogger)new OllamaRestApi.OllamaLogger(logRequests, logResponses));
            }
            if ((maybeModelAuthProvider = ModelAuthProvider.resolve((String)configName)).isPresent()) {
                builder.register((Object)new OllamaModelAuthProviderFilter((ModelAuthProvider)maybeModelAuthProvider.get()));
            }
            if ((tlsConfigurationRegistry = CDI.current().select(TlsConfigurationRegistry.class, new Annotation[0])).isResolvable()) {
                TlsConfiguration.from((TlsConfigurationRegistry)((TlsConfigurationRegistry)tlsConfigurationRegistry.get()), Optional.ofNullable(tlsConfigurationName)).ifPresent(arg_0 -> ((QuarkusRestClientBuilder)builder).tlsConfiguration(arg_0));
            }
            this.restApi = (OllamaRestApi)builder.build(OllamaRestApi.class);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public ChatResponse chat(ChatRequest request) {
        return this.restApi.chat(request);
    }

    public Multi<ChatResponse> streamingChat(ChatRequest request) {
        return this.restApi.streamingChat(request);
    }

    public EmbeddingResponse embedding(EmbeddingRequest request) {
        return this.restApi.embeddings(request);
    }
}

