/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.openai.deployment;

import com.knuddels.jtokkit.Encodings;
import io.quarkiverse.langchain4j.deployment.JarResourceUtil;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;

public class OpenAiCommonProcessor {
    @BuildStep
    void indexDependencies(BuildProducer<IndexDependencyBuildItem> producer) {
        producer.produce((BuildItem)new IndexDependencyBuildItem("dev.ai4j", "openai4j"));
    }

    @BuildStep
    void nativeImageSupport(BuildProducer<NativeImageResourceBuildItem> resourcesProducer) {
        this.registerJtokkitResources(resourcesProducer);
    }

    private void registerJtokkitResources(BuildProducer<NativeImageResourceBuildItem> resourcesProducer) {
        ArrayList<String> resources = new ArrayList<String>();
        try (JarFile jarFile = new JarFile(JarResourceUtil.determineJarLocation(Encodings.class).toFile());){
            Enumeration<JarEntry> e2 = jarFile.entries();
            while (e2.hasMoreElements()) {
                String name = e2.nextElement().getName();
                if (!name.endsWith(".tiktoken")) continue;
                resources.add(name);
            }
        }
        catch (IOException e3) {
            throw new UncheckedIOException(e3);
        }
        List names = JarResourceUtil.matchingJarEntries((Path)JarResourceUtil.determineJarLocation(Encodings.class), e -> e.getName().endsWith(".tiktoken")).stream().map(ZipEntry::getName).collect(Collectors.toList());
        if (!names.isEmpty()) {
            resourcesProducer.produce((BuildItem)new NativeImageResourceBuildItem(resources));
        }
    }
}

