/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.openai;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import dev.ai4j.openai4j.OpenAiHttpException;
import dev.ai4j.openai4j.chat.ChatCompletionRequest;
import dev.ai4j.openai4j.chat.ChatCompletionResponse;
import dev.ai4j.openai4j.completion.CompletionRequest;
import dev.ai4j.openai4j.completion.CompletionResponse;
import dev.ai4j.openai4j.embedding.EmbeddingRequest;
import dev.ai4j.openai4j.embedding.EmbeddingResponse;
import dev.ai4j.openai4j.image.GenerateImagesRequest;
import dev.ai4j.openai4j.image.GenerateImagesResponse;
import dev.ai4j.openai4j.moderation.ModerationRequest;
import dev.ai4j.openai4j.moderation.ModerationResponse;
import io.quarkiverse.langchain4j.QuarkusJsonCodecFactory;
import io.quarkiverse.langchain4j.openai.OpenAiApiException;
import io.quarkus.rest.client.reactive.ClientExceptionMapper;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import jakarta.annotation.Priority;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.rest.client.annotation.RegisterProvider;
import org.eclipse.microprofile.rest.client.annotation.RegisterProviders;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.RestStreamElementType;
import org.jboss.resteasy.reactive.client.SseEvent;
import org.jboss.resteasy.reactive.client.SseEventFilter;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.common.providers.serialisers.AbstractJsonMessageBodyReader;

@Path(value="")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@RegisterProviders(value={@RegisterProvider(value=OpenAiRestApiJacksonReader.class), @RegisterProvider(value=OpenAiRestApiJacksonWriter.class), @RegisterProvider(value=OpenAiRestApiReaderInterceptor.class), @RegisterProvider(value=OpenAiRestApiWriterInterceptor.class)})
public interface OpenAiRestApi {
    @Path(value="completions")
    @POST
    public Uni<CompletionResponse> completion(CompletionRequest var1, @BeanParam ApiMetadata var2);

    @Path(value="completions")
    @POST
    public CompletionResponse blockingCompletion(CompletionRequest var1, @BeanParam ApiMetadata var2);

    @Path(value="chat/completions")
    @POST
    @RestStreamElementType(value="application/json")
    @SseEventFilter(value=DoneFilter.class)
    public Multi<CompletionResponse> streamingCompletion(CompletionRequest var1, @BeanParam ApiMetadata var2);

    @Path(value="chat/completions")
    @POST
    public Uni<ChatCompletionResponse> createChatCompletion(ChatCompletionRequest var1, @BeanParam ApiMetadata var2);

    @Path(value="chat/completions")
    @POST
    public ChatCompletionResponse blockingChatCompletion(ChatCompletionRequest var1, @BeanParam ApiMetadata var2);

    @Path(value="chat/completions")
    @POST
    @RestStreamElementType(value="application/json")
    @SseEventFilter(value=DoneFilter.class)
    public Multi<ChatCompletionResponse> streamingChatCompletion(ChatCompletionRequest var1, @BeanParam ApiMetadata var2);

    @Path(value="embeddings")
    @POST
    public Uni<EmbeddingResponse> embedding(EmbeddingRequest var1, @BeanParam ApiMetadata var2);

    @Path(value="embeddings")
    @POST
    public EmbeddingResponse blockingEmbedding(EmbeddingRequest var1, @BeanParam ApiMetadata var2);

    @Path(value="moderations")
    @POST
    public Uni<ModerationResponse> moderation(ModerationRequest var1, @BeanParam ApiMetadata var2);

    @Path(value="moderations")
    @POST
    public ModerationResponse blockingModeration(ModerationRequest var1, @BeanParam ApiMetadata var2);

    @Path(value="images/generations")
    @POST
    public GenerateImagesResponse blockingImagesGenerations(GenerateImagesRequest var1, @BeanParam ApiMetadata var2);

    @Path(value="images/generations")
    @POST
    public Uni<GenerateImagesResponse> imagesGenerations(GenerateImagesRequest var1, @BeanParam ApiMetadata var2);

    @ClientExceptionMapper
    public static RuntimeException toException(Response response) {
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            return new OpenAiHttpException(response.getStatus(), (String)response.readEntity(String.class));
        }
        return null;
    }

    public static class ApiMetadata {
        @HeaderParam(value="Authorization")
        public final String authorization;
        @HeaderParam(value="api-key")
        public final String apiKey;
        @QueryParam(value="api-version")
        public final String apiVersion;
        @HeaderParam(value="OpenAI-Organization")
        public final String organizationId;

        private ApiMetadata(String authorization, String apiKey, String apiVersion, String organizationId) {
            this.authorization = authorization;
            this.apiKey = apiKey;
            this.apiVersion = apiVersion;
            this.organizationId = organizationId;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String apiKey;
            private String apiVersion;
            private String organizationId;

            public ApiMetadata build() {
                return this.apiKey == null ? new ApiMetadata(null, null, this.apiVersion, this.organizationId) : new ApiMetadata("Bearer " + this.apiKey, this.apiKey, this.apiVersion, this.organizationId);
            }

            public Builder apiKey(String apiKey) {
                this.apiKey = apiKey;
                return this;
            }

            public Builder apiVersion(String apiVersion) {
                this.apiVersion = apiVersion;
                return this;
            }

            public Builder organizationId(String organizationId) {
                this.organizationId = organizationId;
                return this;
            }
        }
    }

    public static class OpenAiClientLogger
    implements ClientLogger {
        private static final Logger log = Logger.getLogger(OpenAiClientLogger.class);
        private static final Pattern BEARER_PATTERN = Pattern.compile("(Bearer\\s*sk-)(\\w{2})(\\w+)(\\w{2})");
        private final boolean logRequests;
        private final boolean logResponses;

        public OpenAiClientLogger(boolean logRequests, boolean logResponses) {
            this.logRequests = logRequests;
            this.logResponses = logResponses;
        }

        public void setBodySize(int bodySize) {
        }

        public void logRequest(HttpClientRequest request, Buffer body, boolean omitBody) {
            if (!this.logRequests || !log.isInfoEnabled()) {
                return;
            }
            try {
                log.infof("Request:\n- method: %s\n- url: %s\n- headers: %s\n- body: %s", new Object[]{request.getMethod(), request.absoluteURI(), this.inOneLine(request.headers()), this.bodyToString(body)});
            }
            catch (Exception e) {
                log.warn((Object)"Failed to log request", (Throwable)e);
            }
        }

        public void logResponse(final HttpClientResponse response, boolean redirect) {
            if (!this.logResponses || !log.isInfoEnabled()) {
                return;
            }
            response.bodyHandler((Handler)new Handler<Buffer>(){

                public void handle(Buffer body) {
                    try {
                        log.infof("Response:\n- status code: %s\n- headers: %s\n- body: %s", (Object)response.statusCode(), (Object)this.inOneLine(response.headers()), (Object)this.bodyToString(body));
                    }
                    catch (Exception e) {
                        log.warn((Object)"Failed to log response", (Throwable)e);
                    }
                }
            });
        }

        private String bodyToString(Buffer body) {
            if (body == null) {
                return "";
            }
            return body.toString();
        }

        private String inOneLine(MultiMap headers) {
            return StreamSupport.stream(headers.spliterator(), false).map(header -> {
                String headerKey = (String)header.getKey();
                String headerValue = (String)header.getValue();
                if (headerKey.equals("Authorization")) {
                    headerValue = OpenAiClientLogger.maskAuthorizationHeaderValue(headerValue);
                } else if (headerKey.equals("api-key")) {
                    headerValue = OpenAiClientLogger.maskApiKeyHeaderValue(headerValue);
                }
                return String.format("[%s: %s]", headerKey, headerValue);
            }).collect(Collectors.joining(", "));
        }

        private static String maskAuthorizationHeaderValue(String authorizationHeaderValue) {
            try {
                Matcher matcher = BEARER_PATTERN.matcher(authorizationHeaderValue);
                StringBuilder sb = new StringBuilder();
                while (matcher.find()) {
                    matcher.appendReplacement(sb, matcher.group(1) + matcher.group(2) + "..." + matcher.group(4));
                }
                matcher.appendTail(sb);
                return sb.toString();
            }
            catch (Exception e) {
                return "Failed to mask the API key.";
            }
        }

        private static String maskApiKeyHeaderValue(String apiKeyHeaderValue) {
            try {
                if (apiKeyHeaderValue.length() <= 4) {
                    return apiKeyHeaderValue;
                }
                return apiKeyHeaderValue.substring(0, 2) + "..." + apiKeyHeaderValue.substring(apiKeyHeaderValue.length() - 2);
            }
            catch (Exception e) {
                return "Failed to mask the API key.";
            }
        }
    }

    public static class OpenAiRestApiWriterInterceptor
    implements WriterInterceptor {
        public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
            Object entity = context.getEntity();
            if (entity instanceof ChatCompletionRequest) {
                ChatCompletionRequest request = (ChatCompletionRequest)entity;
                MultivaluedMap headers = context.getHeaders();
                List acceptList = (List)headers.get((Object)"Accept");
                if (acceptList != null && acceptList.size() == 1) {
                    String accept = (String)acceptList.get(0);
                    if ("application/json".equals(accept)) {
                        if (Boolean.TRUE.equals(request.stream())) {
                            context.setEntity((Object)ChatCompletionRequest.builder().from(request).stream(null).build());
                        }
                    } else if ("text/event-stream".equals(accept) && !Boolean.TRUE.equals(request.stream())) {
                        context.setEntity((Object)ChatCompletionRequest.builder().from(request).stream(Boolean.valueOf(true)).build());
                    }
                }
            }
            context.proceed();
        }
    }

    public static class OpenAiRestApiReaderInterceptor
    implements ReaderInterceptor {
        public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
            return this.validateResponse(context.proceed());
        }

        private Object validateResponse(Object result) {
            ModerationResponse r;
            if (result instanceof ChatCompletionResponse) {
                ChatCompletionResponse r2 = (ChatCompletionResponse)result;
                if (r2.id() == null) {
                    throw new OpenAiApiException(ChatCompletionResponse.class);
                }
            } else if (result instanceof CompletionResponse) {
                CompletionResponse r3 = (CompletionResponse)result;
                if (r3.id() == null) {
                    throw new OpenAiApiException(CompletionResponse.class);
                }
            } else if (result instanceof ModerationResponse && (r = (ModerationResponse)result).id() == null) {
                throw new OpenAiApiException(ModerationResponse.class);
            }
            return result;
        }
    }

    public static class ObjectMapperHolder {
        public static final ObjectMapper MAPPER = QuarkusJsonCodecFactory.SnakeCaseObjectMapperHolder.MAPPER;
        private static final ObjectReader READER = MAPPER.reader();
    }

    @Priority(value=4900)
    public static class OpenAiRestApiJacksonReader
    extends AbstractJsonMessageBodyReader {
        public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return true;
        }

        public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            return ObjectMapperHolder.READER.forType(ObjectMapperHolder.READER.getTypeFactory().constructType(genericType != null ? genericType : type)).readValue(entityStream);
        }
    }

    @Priority(value=5100)
    public static class OpenAiRestApiJacksonWriter
    implements MessageBodyWriter<Object> {
        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return true;
        }

        public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
            entityStream.write(ObjectMapperHolder.MAPPER.writeValueAsString(o).getBytes(StandardCharsets.UTF_8));
        }
    }

    public static class DoneFilter
    implements Predicate<SseEvent<String>> {
        @Override
        public boolean test(SseEvent<String> event) {
            return !"[DONE]".equals(event.data());
        }
    }
}

