/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.openai.deployment;

import io.quarkiverse.langchain4j.ModelName;
import io.quarkiverse.langchain4j.deployment.LangChain4jDotNames;
import io.quarkiverse.langchain4j.deployment.items.ChatModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.EmbeddingModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.ImageModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.ModerationModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedChatModelProviderBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedEmbeddingModelCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedImageModelProviderBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedModerationModelProviderBuildItem;
import io.quarkiverse.langchain4j.openai.deployment.LangChain4jOpenAiBuildConfig;
import io.quarkiverse.langchain4j.openai.runtime.OpenAiRecorder;
import io.quarkiverse.langchain4j.openai.runtime.config.LangChain4jOpenAiConfig;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.runtime.ShutdownContext;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;

public class OpenAiProcessor {
    private static final String FEATURE = "langchain4j-openai";
    private static final String PROVIDER = "openai";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public void providerCandidates(BuildProducer<ChatModelProviderCandidateBuildItem> chatProducer, BuildProducer<EmbeddingModelProviderCandidateBuildItem> embeddingProducer, BuildProducer<ModerationModelProviderCandidateBuildItem> moderationProducer, BuildProducer<ImageModelProviderCandidateBuildItem> imageProducer, LangChain4jOpenAiBuildConfig config) {
        if (config.chatModel().enabled().isEmpty() || config.chatModel().enabled().get().booleanValue()) {
            chatProducer.produce((BuildItem)new ChatModelProviderCandidateBuildItem(PROVIDER));
        }
        if (config.embeddingModel().enabled().isEmpty() || config.embeddingModel().enabled().get().booleanValue()) {
            embeddingProducer.produce((BuildItem)new EmbeddingModelProviderCandidateBuildItem(PROVIDER));
        }
        if (config.moderationModel().enabled().isEmpty() || config.moderationModel().enabled().get().booleanValue()) {
            moderationProducer.produce((BuildItem)new ModerationModelProviderCandidateBuildItem(PROVIDER));
        }
        if (config.imageModel().enabled().isEmpty() || config.imageModel().enabled().get().booleanValue()) {
            imageProducer.produce((BuildItem)new ImageModelProviderCandidateBuildItem(PROVIDER));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void generateBeans(OpenAiRecorder recorder, List<SelectedChatModelProviderBuildItem> selectedChatItem, List<SelectedEmbeddingModelCandidateBuildItem> selectedEmbedding, List<SelectedModerationModelProviderBuildItem> selectedModeration, List<SelectedImageModelProviderBuildItem> selectedImage, LangChain4jOpenAiConfig config, BuildProducer<SyntheticBeanBuildItem> beanProducer) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator builder;
        String configName;
        for (SelectedChatModelProviderBuildItem selectedChatModelProviderBuildItem : selectedChatItem) {
            if (!PROVIDER.equals(selectedChatModelProviderBuildItem.getProvider())) continue;
            configName = selectedChatModelProviderBuildItem.getConfigName();
            builder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)LangChain4jDotNames.CHAT_MODEL).setRuntimeInit().defaultBean()).scope(ApplicationScoped.class)).supplier(recorder.chatModel(config, configName));
            this.addQualifierIfNecessary(builder, configName);
            beanProducer.produce((BuildItem)builder.done());
            SyntheticBeanBuildItem.ExtendedBeanConfigurator streamingBuilder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)LangChain4jDotNames.STREAMING_CHAT_MODEL).setRuntimeInit().defaultBean()).scope(ApplicationScoped.class)).supplier(recorder.streamingChatModel(config, configName));
            this.addQualifierIfNecessary(streamingBuilder, configName);
            beanProducer.produce((BuildItem)streamingBuilder.done());
        }
        for (SelectedEmbeddingModelCandidateBuildItem selectedEmbeddingModelCandidateBuildItem : selectedEmbedding) {
            if (!PROVIDER.equals(selectedEmbeddingModelCandidateBuildItem.getProvider())) continue;
            configName = selectedEmbeddingModelCandidateBuildItem.getConfigName();
            builder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)LangChain4jDotNames.EMBEDDING_MODEL).setRuntimeInit().defaultBean()).unremovable()).scope(ApplicationScoped.class)).supplier(recorder.embeddingModel(config, configName));
            this.addQualifierIfNecessary(builder, configName);
            beanProducer.produce((BuildItem)builder.done());
        }
        for (SelectedModerationModelProviderBuildItem selectedModerationModelProviderBuildItem : selectedModeration) {
            if (!PROVIDER.equals(selectedModerationModelProviderBuildItem.getProvider())) continue;
            configName = selectedModerationModelProviderBuildItem.getConfigName();
            builder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)LangChain4jDotNames.MODERATION_MODEL).setRuntimeInit().defaultBean()).scope(ApplicationScoped.class)).supplier(recorder.moderationModel(config, configName));
            this.addQualifierIfNecessary(builder, configName);
            beanProducer.produce((BuildItem)builder.done());
        }
        for (SelectedImageModelProviderBuildItem selectedImageModelProviderBuildItem : selectedImage) {
            if (!PROVIDER.equals(selectedImageModelProviderBuildItem.getProvider())) continue;
            configName = selectedImageModelProviderBuildItem.getConfigName();
            builder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)LangChain4jDotNames.IMAGE_MODEL).setRuntimeInit().defaultBean()).scope(ApplicationScoped.class)).supplier(recorder.imageModel(config, configName));
            this.addQualifierIfNecessary(builder, configName);
            beanProducer.produce((BuildItem)builder.done());
        }
    }

    private void addQualifierIfNecessary(SyntheticBeanBuildItem.ExtendedBeanConfigurator builder, String configName) {
        if (!NamedConfigUtil.isDefault((String)configName)) {
            builder.addQualifier(AnnotationInstance.builder(ModelName.class).add("value", configName).build());
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void cleanUp(OpenAiRecorder recorder, ShutdownContextBuildItem shutdown) {
        recorder.cleanUp((ShutdownContext)shutdown);
    }
}

