/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.openai.runtime;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.DisabledChatLanguageModel;
import dev.langchain4j.model.chat.DisabledStreamingChatLanguageModel;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.embedding.DisabledEmbeddingModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.image.DisabledImageModel;
import dev.langchain4j.model.image.ImageModel;
import dev.langchain4j.model.moderation.DisabledModerationModel;
import dev.langchain4j.model.moderation.ModerationModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.openai.OpenAiEmbeddingModel;
import dev.langchain4j.model.openai.OpenAiModerationModel;
import dev.langchain4j.model.openai.OpenAiStreamingChatModel;
import io.quarkiverse.langchain4j.openai.QuarkusOpenAiClient;
import io.quarkiverse.langchain4j.openai.QuarkusOpenAiImageModel;
import io.quarkiverse.langchain4j.openai.runtime.config.ChatModelConfig;
import io.quarkiverse.langchain4j.openai.runtime.config.EmbeddingModelConfig;
import io.quarkiverse.langchain4j.openai.runtime.config.ImageModelConfig;
import io.quarkiverse.langchain4j.openai.runtime.config.LangChain4jOpenAiConfig;
import io.quarkiverse.langchain4j.openai.runtime.config.ModerationModelConfig;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.config.ConfigValidationException;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@Recorder
public class OpenAiRecorder {
    private static final TypeLiteral<Instance<ChatModelListener>> CHAT_MODEL_LISTENER_TYPE_LITERAL = new TypeLiteral<Instance<ChatModelListener>>(){};
    private static final String DUMMY_KEY = "dummy";
    private static final String OPENAI_BASE_URL = "https://api.openai.com/v1/";

    public Function<SyntheticCreationalContext<ChatLanguageModel>, ChatLanguageModel> chatModel(LangChain4jOpenAiConfig runtimeConfig, String configName) {
        LangChain4jOpenAiConfig.OpenAiConfig openAiConfig = this.correspondingOpenAiConfig(runtimeConfig, configName);
        if (openAiConfig.enableIntegration().booleanValue()) {
            String apiKey = openAiConfig.apiKey();
            if (DUMMY_KEY.equals(apiKey) && OPENAI_BASE_URL.equals(openAiConfig.baseUrl())) {
                throw new ConfigValidationException(this.createApiKeyConfigProblems(configName));
            }
            ChatModelConfig chatModelConfig = openAiConfig.chatModel();
            final OpenAiChatModel.OpenAiChatModelBuilder builder = OpenAiChatModel.builder().baseUrl(openAiConfig.baseUrl()).apiKey(apiKey).timeout(openAiConfig.timeout().orElse(Duration.ofSeconds(10L))).maxRetries(openAiConfig.maxRetries()).logRequests(chatModelConfig.logRequests().orElse(false)).logResponses(chatModelConfig.logResponses().orElse(false)).modelName(chatModelConfig.modelName()).temperature(chatModelConfig.temperature()).topP(chatModelConfig.topP()).presencePenalty(chatModelConfig.presencePenalty()).frequencyPenalty(chatModelConfig.frequencyPenalty()).responseFormat((String)chatModelConfig.responseFormat().orElse(null)).stop((List)chatModelConfig.stop().orElse(null));
            openAiConfig.organizationId().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).organizationId(arg_0));
            openAiConfig.proxyHost().ifPresent(host -> builder.proxy(new Proxy(Proxy.Type.valueOf(openAiConfig.proxyType()), new InetSocketAddress((String)host, (int)openAiConfig.proxyPort()))));
            if (chatModelConfig.maxTokens().isPresent()) {
                builder.maxTokens(chatModelConfig.maxTokens().get());
            }
            return new Function<SyntheticCreationalContext<ChatLanguageModel>, ChatLanguageModel>(){

                @Override
                public ChatLanguageModel apply(SyntheticCreationalContext<ChatLanguageModel> context) {
                    builder.listeners(((Instance)context.getInjectedReference(CHAT_MODEL_LISTENER_TYPE_LITERAL, new Annotation[0])).stream().collect(Collectors.toList()));
                    return builder.build();
                }
            };
        }
        return new Function<SyntheticCreationalContext<ChatLanguageModel>, ChatLanguageModel>(){

            @Override
            public ChatLanguageModel apply(SyntheticCreationalContext<ChatLanguageModel> context) {
                return new DisabledChatLanguageModel();
            }
        };
    }

    public Supplier<StreamingChatLanguageModel> streamingChatModel(LangChain4jOpenAiConfig runtimeConfig, String configName) {
        LangChain4jOpenAiConfig.OpenAiConfig openAiConfig = this.correspondingOpenAiConfig(runtimeConfig, configName);
        if (openAiConfig.enableIntegration().booleanValue()) {
            String apiKey = openAiConfig.apiKey();
            if (DUMMY_KEY.equals(apiKey) && OPENAI_BASE_URL.equals(openAiConfig.baseUrl())) {
                throw new ConfigValidationException(this.createApiKeyConfigProblems(configName));
            }
            ChatModelConfig chatModelConfig = openAiConfig.chatModel();
            final OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder builder = OpenAiStreamingChatModel.builder().baseUrl(openAiConfig.baseUrl()).apiKey(apiKey).timeout(openAiConfig.timeout().orElse(Duration.ofSeconds(10L))).logRequests(chatModelConfig.logRequests().orElse(false)).logResponses(chatModelConfig.logResponses().orElse(false)).modelName(chatModelConfig.modelName()).temperature(chatModelConfig.temperature()).topP(chatModelConfig.topP()).presencePenalty(chatModelConfig.presencePenalty()).frequencyPenalty(chatModelConfig.frequencyPenalty()).responseFormat((String)chatModelConfig.responseFormat().orElse(null)).stop((List)chatModelConfig.stop().orElse(null));
            openAiConfig.organizationId().ifPresent(arg_0 -> ((OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder)builder).organizationId(arg_0));
            openAiConfig.proxyHost().ifPresent(host -> builder.proxy(new Proxy(Proxy.Type.valueOf(openAiConfig.proxyType()), new InetSocketAddress((String)host, (int)openAiConfig.proxyPort()))));
            if (chatModelConfig.maxTokens().isPresent()) {
                builder.maxTokens(chatModelConfig.maxTokens().get());
            }
            return new Supplier<StreamingChatLanguageModel>(){

                @Override
                public StreamingChatLanguageModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<StreamingChatLanguageModel>(){

            @Override
            public StreamingChatLanguageModel get() {
                return new DisabledStreamingChatLanguageModel();
            }
        };
    }

    public Supplier<EmbeddingModel> embeddingModel(LangChain4jOpenAiConfig runtimeConfig, String configName) {
        LangChain4jOpenAiConfig.OpenAiConfig openAiConfig = this.correspondingOpenAiConfig(runtimeConfig, configName);
        if (openAiConfig.enableIntegration().booleanValue()) {
            String apiKey = openAiConfig.apiKey();
            if (DUMMY_KEY.equals(apiKey) && OPENAI_BASE_URL.equals(openAiConfig.baseUrl())) {
                throw new ConfigValidationException(this.createApiKeyConfigProblems(configName));
            }
            EmbeddingModelConfig embeddingModelConfig = openAiConfig.embeddingModel();
            final OpenAiEmbeddingModel.OpenAiEmbeddingModelBuilder builder = OpenAiEmbeddingModel.builder().baseUrl(openAiConfig.baseUrl()).apiKey(apiKey).timeout(openAiConfig.timeout().orElse(Duration.ofSeconds(10L))).maxRetries(openAiConfig.maxRetries()).logRequests(embeddingModelConfig.logRequests().orElse(false)).logResponses(embeddingModelConfig.logResponses().orElse(false)).modelName(embeddingModelConfig.modelName());
            if (embeddingModelConfig.user().isPresent()) {
                builder.user(embeddingModelConfig.user().get());
            }
            openAiConfig.organizationId().ifPresent(arg_0 -> ((OpenAiEmbeddingModel.OpenAiEmbeddingModelBuilder)builder).organizationId(arg_0));
            openAiConfig.proxyHost().ifPresent(host -> builder.proxy(new Proxy(Proxy.Type.valueOf(openAiConfig.proxyType()), new InetSocketAddress((String)host, (int)openAiConfig.proxyPort()))));
            return new Supplier<EmbeddingModel>(){

                @Override
                public EmbeddingModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<EmbeddingModel>(){

            @Override
            public EmbeddingModel get() {
                return new DisabledEmbeddingModel();
            }
        };
    }

    public Supplier<ModerationModel> moderationModel(LangChain4jOpenAiConfig runtimeConfig, String configName) {
        LangChain4jOpenAiConfig.OpenAiConfig openAiConfig = this.correspondingOpenAiConfig(runtimeConfig, configName);
        if (openAiConfig.enableIntegration().booleanValue()) {
            String apiKey = openAiConfig.apiKey();
            if (DUMMY_KEY.equals(apiKey) && OPENAI_BASE_URL.equals(openAiConfig.baseUrl())) {
                throw new ConfigValidationException(this.createApiKeyConfigProblems(configName));
            }
            ModerationModelConfig moderationModelConfig = openAiConfig.moderationModel();
            final OpenAiModerationModel.OpenAiModerationModelBuilder builder = OpenAiModerationModel.builder().baseUrl(openAiConfig.baseUrl()).apiKey(apiKey).timeout(openAiConfig.timeout().orElse(Duration.ofSeconds(10L))).maxRetries(openAiConfig.maxRetries()).logRequests(moderationModelConfig.logRequests().orElse(false)).logResponses(moderationModelConfig.logResponses().orElse(false)).modelName(moderationModelConfig.modelName());
            openAiConfig.organizationId().ifPresent(arg_0 -> ((OpenAiModerationModel.OpenAiModerationModelBuilder)builder).organizationId(arg_0));
            openAiConfig.proxyHost().ifPresent(host -> builder.proxy(new Proxy(Proxy.Type.valueOf(openAiConfig.proxyType()), new InetSocketAddress((String)host, (int)openAiConfig.proxyPort()))));
            return new Supplier<ModerationModel>(){

                @Override
                public ModerationModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<ModerationModel>(){

            @Override
            public ModerationModel get() {
                return new DisabledModerationModel();
            }
        };
    }

    public Supplier<ImageModel> imageModel(LangChain4jOpenAiConfig runtimeConfig, String configName) {
        LangChain4jOpenAiConfig.OpenAiConfig openAiConfig = this.correspondingOpenAiConfig(runtimeConfig, configName);
        if (openAiConfig.enableIntegration().booleanValue()) {
            String apiKey = openAiConfig.apiKey();
            if (DUMMY_KEY.equals(apiKey) && OPENAI_BASE_URL.equals(openAiConfig.baseUrl())) {
                throw new ConfigValidationException(this.createApiKeyConfigProblems(configName));
            }
            ImageModelConfig imageModelConfig = openAiConfig.imageModel();
            final QuarkusOpenAiImageModel.Builder builder = QuarkusOpenAiImageModel.builder().baseUrl(openAiConfig.baseUrl()).apiKey(apiKey).timeout(openAiConfig.timeout().orElse(Duration.ofSeconds(10L))).maxRetries(openAiConfig.maxRetries()).logRequests(imageModelConfig.logRequests().orElse(false)).logResponses(imageModelConfig.logResponses().orElse(false)).modelName(imageModelConfig.modelName()).size(imageModelConfig.size()).quality(imageModelConfig.quality()).style(imageModelConfig.style()).responseFormat(imageModelConfig.responseFormat()).user(imageModelConfig.user());
            openAiConfig.organizationId().ifPresent(builder::organizationId);
            Optional<Path> persistDirectory = Optional.empty();
            if (imageModelConfig.persist().isPresent()) {
                if (imageModelConfig.persist().get().booleanValue()) {
                    persistDirectory = imageModelConfig.persistDirectory().or((Supplier<Optional<Path>>)new Supplier<Optional<? extends Path>>(){

                        @Override
                        public Optional<? extends Path> get() {
                            return Optional.of(Paths.get(System.getProperty("java.io.tmpdir"), "dall-e-images"));
                        }
                    });
                }
            } else if (imageModelConfig.persistDirectory().isPresent()) {
                persistDirectory = imageModelConfig.persistDirectory();
            }
            builder.persistDirectory(persistDirectory);
            return new Supplier<ImageModel>(){

                @Override
                public ImageModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<ImageModel>(){

            @Override
            public ImageModel get() {
                return new DisabledImageModel();
            }
        };
    }

    private LangChain4jOpenAiConfig.OpenAiConfig correspondingOpenAiConfig(LangChain4jOpenAiConfig runtimeConfig, String configName) {
        LangChain4jOpenAiConfig.OpenAiConfig openAiConfig = NamedConfigUtil.isDefault((String)configName) ? runtimeConfig.defaultConfig() : runtimeConfig.namedConfig().get(configName);
        return openAiConfig;
    }

    private ConfigValidationException.Problem[] createApiKeyConfigProblems(String configName) {
        return this.createConfigProblems("api-key", configName);
    }

    private ConfigValidationException.Problem[] createConfigProblems(String key, String configName) {
        return new ConfigValidationException.Problem[]{this.createConfigProblem(key, configName)};
    }

    private ConfigValidationException.Problem createConfigProblem(String key, String configName) {
        return new ConfigValidationException.Problem(String.format("SRCFG00014: The config property quarkus.langchain4j.openai%s%s is required but it could not be found in any config source", NamedConfigUtil.isDefault((String)configName) ? "." : "." + configName + ".", key));
    }

    public void cleanUp(ShutdownContext shutdown) {
        shutdown.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                QuarkusOpenAiClient.clearCache();
            }
        });
    }
}

