/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.openai.runtime;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.DisabledChatLanguageModel;
import dev.langchain4j.model.chat.DisabledStreamingChatLanguageModel;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.embedding.DisabledEmbeddingModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.image.DisabledImageModel;
import dev.langchain4j.model.image.ImageModel;
import dev.langchain4j.model.moderation.DisabledModerationModel;
import dev.langchain4j.model.moderation.ModerationModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.openai.OpenAiEmbeddingModel;
import dev.langchain4j.model.openai.OpenAiModerationModel;
import dev.langchain4j.model.openai.OpenAiStreamingChatModel;
import io.quarkiverse.langchain4j.openai.QuarkusOpenAiClient;
import io.quarkiverse.langchain4j.openai.QuarkusOpenAiImageModel;
import io.quarkiverse.langchain4j.openai.runtime.config.ChatModelConfig;
import io.quarkiverse.langchain4j.openai.runtime.config.EmbeddingModelConfig;
import io.quarkiverse.langchain4j.openai.runtime.config.ImageModelConfig;
import io.quarkiverse.langchain4j.openai.runtime.config.Langchain4jOpenAiConfig;
import io.quarkiverse.langchain4j.openai.runtime.config.ModerationModelConfig;
import io.quarkiverse.langchain4j.runtime.NamedModelUtil;
import io.quarkiverse.langchain4j.runtime.OptionalUtil;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.config.ConfigValidationException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Supplier;

@Recorder
public class OpenAiRecorder {
    private static final String DUMMY_KEY = "dummy";

    public Supplier<ChatLanguageModel> chatModel(Langchain4jOpenAiConfig runtimeConfig, String modelName) {
        Langchain4jOpenAiConfig.OpenAiConfig openAiConfig = this.correspondingOpenAiConfig(runtimeConfig, modelName);
        if (openAiConfig.enableIntegration().booleanValue()) {
            String apiKey = openAiConfig.apiKey();
            if (DUMMY_KEY.equals(apiKey)) {
                throw new ConfigValidationException(this.createApiKeyConfigProblems(modelName));
            }
            ChatModelConfig chatModelConfig = openAiConfig.chatModel();
            final OpenAiChatModel.OpenAiChatModelBuilder builder = OpenAiChatModel.builder().baseUrl(openAiConfig.baseUrl()).apiKey(apiKey).timeout(openAiConfig.timeout()).maxRetries(openAiConfig.maxRetries()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logRequests(), openAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logResponses(), openAiConfig.logResponses()})).modelName(chatModelConfig.modelName()).temperature(chatModelConfig.temperature()).topP(chatModelConfig.topP()).presencePenalty(chatModelConfig.presencePenalty()).frequencyPenalty(chatModelConfig.frequencyPenalty()).responseFormat((String)chatModelConfig.responseFormat().orElse(null));
            openAiConfig.organizationId().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).organizationId(arg_0));
            if (chatModelConfig.maxTokens().isPresent()) {
                builder.maxTokens(chatModelConfig.maxTokens().get());
            }
            return new Supplier<ChatLanguageModel>(){

                @Override
                public ChatLanguageModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<ChatLanguageModel>(){

            @Override
            public ChatLanguageModel get() {
                return new DisabledChatLanguageModel();
            }
        };
    }

    public Supplier<StreamingChatLanguageModel> streamingChatModel(Langchain4jOpenAiConfig runtimeConfig, String modelName) {
        Langchain4jOpenAiConfig.OpenAiConfig openAiConfig = this.correspondingOpenAiConfig(runtimeConfig, modelName);
        if (openAiConfig.enableIntegration().booleanValue()) {
            String apiKey = openAiConfig.apiKey();
            if (DUMMY_KEY.equals(apiKey)) {
                throw new ConfigValidationException(this.createApiKeyConfigProblems(modelName));
            }
            ChatModelConfig chatModelConfig = openAiConfig.chatModel();
            final OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder builder = OpenAiStreamingChatModel.builder().baseUrl(openAiConfig.baseUrl()).apiKey(apiKey).timeout(openAiConfig.timeout()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logRequests(), openAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logResponses(), openAiConfig.logResponses()})).modelName(chatModelConfig.modelName()).temperature(chatModelConfig.temperature()).topP(chatModelConfig.topP()).presencePenalty(chatModelConfig.presencePenalty()).frequencyPenalty(chatModelConfig.frequencyPenalty()).responseFormat((String)chatModelConfig.responseFormat().orElse(null));
            openAiConfig.organizationId().ifPresent(arg_0 -> ((OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder)builder).organizationId(arg_0));
            if (chatModelConfig.maxTokens().isPresent()) {
                builder.maxTokens(chatModelConfig.maxTokens().get());
            }
            return new Supplier<StreamingChatLanguageModel>(){

                @Override
                public StreamingChatLanguageModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<StreamingChatLanguageModel>(){

            @Override
            public StreamingChatLanguageModel get() {
                return new DisabledStreamingChatLanguageModel();
            }
        };
    }

    public Supplier<EmbeddingModel> embeddingModel(Langchain4jOpenAiConfig runtimeConfig, String modelName) {
        Langchain4jOpenAiConfig.OpenAiConfig openAiConfig = this.correspondingOpenAiConfig(runtimeConfig, modelName);
        if (openAiConfig.enableIntegration().booleanValue()) {
            String apiKeyOpt = openAiConfig.apiKey();
            if (DUMMY_KEY.equals(apiKeyOpt)) {
                throw new ConfigValidationException(this.createApiKeyConfigProblems(modelName));
            }
            EmbeddingModelConfig embeddingModelConfig = openAiConfig.embeddingModel();
            final OpenAiEmbeddingModel.OpenAiEmbeddingModelBuilder builder = OpenAiEmbeddingModel.builder().baseUrl(openAiConfig.baseUrl()).apiKey(apiKeyOpt).timeout(openAiConfig.timeout()).maxRetries(openAiConfig.maxRetries()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{embeddingModelConfig.logRequests(), openAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{embeddingModelConfig.logResponses(), openAiConfig.logResponses()})).modelName(embeddingModelConfig.modelName());
            if (embeddingModelConfig.user().isPresent()) {
                builder.user(embeddingModelConfig.user().get());
            }
            openAiConfig.organizationId().ifPresent(arg_0 -> ((OpenAiEmbeddingModel.OpenAiEmbeddingModelBuilder)builder).organizationId(arg_0));
            return new Supplier<EmbeddingModel>(){

                @Override
                public EmbeddingModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<EmbeddingModel>(){

            @Override
            public EmbeddingModel get() {
                return new DisabledEmbeddingModel();
            }
        };
    }

    public Supplier<ModerationModel> moderationModel(Langchain4jOpenAiConfig runtimeConfig, String modelName) {
        Langchain4jOpenAiConfig.OpenAiConfig openAiConfig = this.correspondingOpenAiConfig(runtimeConfig, modelName);
        if (openAiConfig.enableIntegration().booleanValue()) {
            String apiKey = openAiConfig.apiKey();
            if (DUMMY_KEY.equals(apiKey)) {
                throw new ConfigValidationException(this.createApiKeyConfigProblems(modelName));
            }
            ModerationModelConfig moderationModelConfig = openAiConfig.moderationModel();
            final OpenAiModerationModel.OpenAiModerationModelBuilder builder = OpenAiModerationModel.builder().baseUrl(openAiConfig.baseUrl()).apiKey(apiKey).timeout(openAiConfig.timeout()).maxRetries(openAiConfig.maxRetries()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{moderationModelConfig.logRequests(), openAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{moderationModelConfig.logResponses(), openAiConfig.logResponses()})).modelName(moderationModelConfig.modelName());
            openAiConfig.organizationId().ifPresent(arg_0 -> ((OpenAiModerationModel.OpenAiModerationModelBuilder)builder).organizationId(arg_0));
            return new Supplier<ModerationModel>(){

                @Override
                public ModerationModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<ModerationModel>(){

            @Override
            public ModerationModel get() {
                return new DisabledModerationModel();
            }
        };
    }

    public Supplier<ImageModel> imageModel(Langchain4jOpenAiConfig runtimeConfig, String modelName) {
        Langchain4jOpenAiConfig.OpenAiConfig openAiConfig = this.correspondingOpenAiConfig(runtimeConfig, modelName);
        if (openAiConfig.enableIntegration().booleanValue()) {
            String apiKey = openAiConfig.apiKey();
            if (DUMMY_KEY.equals(apiKey)) {
                throw new ConfigValidationException(this.createApiKeyConfigProblems(modelName));
            }
            ImageModelConfig imageModelConfig = openAiConfig.imageModel();
            final QuarkusOpenAiImageModel.Builder builder = QuarkusOpenAiImageModel.builder().baseUrl(openAiConfig.baseUrl()).apiKey(apiKey).timeout(openAiConfig.timeout()).maxRetries(openAiConfig.maxRetries()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{imageModelConfig.logRequests(), openAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{imageModelConfig.logResponses(), openAiConfig.logResponses()})).modelName(imageModelConfig.modelName()).size(imageModelConfig.size()).quality(imageModelConfig.quality()).style(imageModelConfig.style()).responseFormat(imageModelConfig.responseFormat()).user(imageModelConfig.user());
            openAiConfig.organizationId().ifPresent(builder::organizationId);
            Optional<Path> persistDirectory = Optional.empty();
            if (imageModelConfig.persist().isPresent()) {
                if (imageModelConfig.persist().get().booleanValue()) {
                    persistDirectory = imageModelConfig.persistDirectory().or((Supplier<Optional<Path>>)new Supplier<Optional<? extends Path>>(){

                        @Override
                        public Optional<? extends Path> get() {
                            return Optional.of(Paths.get(System.getProperty("java.io.tmpdir"), "dall-e-images"));
                        }
                    });
                }
            } else if (imageModelConfig.persistDirectory().isPresent()) {
                persistDirectory = imageModelConfig.persistDirectory();
            }
            builder.persistDirectory(persistDirectory);
            return new Supplier<ImageModel>(){

                @Override
                public ImageModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<ImageModel>(){

            @Override
            public ImageModel get() {
                return new DisabledImageModel();
            }
        };
    }

    private Langchain4jOpenAiConfig.OpenAiConfig correspondingOpenAiConfig(Langchain4jOpenAiConfig runtimeConfig, String modelName) {
        Langchain4jOpenAiConfig.OpenAiConfig openAiConfig = NamedModelUtil.isDefault((String)modelName) ? runtimeConfig.defaultConfig() : runtimeConfig.namedConfig().get(modelName);
        return openAiConfig;
    }

    private ConfigValidationException.Problem[] createApiKeyConfigProblems(String modelName) {
        return this.createConfigProblems("api-key", modelName);
    }

    private ConfigValidationException.Problem[] createConfigProblems(String key, String modelName) {
        return new ConfigValidationException.Problem[]{this.createConfigProblem(key, modelName)};
    }

    private ConfigValidationException.Problem createConfigProblem(String key, String modelName) {
        return new ConfigValidationException.Problem(String.format("SRCFG00014: The config property quarkus.langchain4j.openai%s%s is required but it could not be found in any config source", NamedModelUtil.isDefault((String)modelName) ? "." : "." + modelName + ".", key));
    }

    public void cleanUp(ShutdownContext shutdown) {
        shutdown.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                QuarkusOpenAiClient.clearCache();
            }
        });
    }
}

