/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.openai.runtime.devui;

import dev.ai4j.openai4j.OpenAiClient;
import dev.ai4j.openai4j.moderation.Categories;
import dev.ai4j.openai4j.moderation.CategoryScores;
import dev.ai4j.openai4j.moderation.ModerationRequest;
import dev.ai4j.openai4j.moderation.ModerationResponse;
import dev.ai4j.openai4j.moderation.ModerationResult;
import dev.langchain4j.internal.RetryUtils;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.time.Duration;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class OpenAiModerationModelsJsonRPCService {
    @Inject
    @ConfigProperty(name="quarkus.langchain4j.openai.base-url")
    String baseUrl;
    @Inject
    @ConfigProperty(name="quarkus.langchain4j.openai.api-key")
    String apiKey;
    @Inject
    @ConfigProperty(name="quarkus.langchain4j.openai.timeout")
    Duration timeout;
    @Inject
    @ConfigProperty(name="quarkus.langchain4j.openai.max-retries")
    Integer maxRetries;
    OpenAiClient client;

    @PostConstruct
    public void init() {
        this.client = OpenAiClient.builder().openAiApiKey(this.apiKey).baseUrl(this.baseUrl).callTimeout(this.timeout).connectTimeout(this.timeout).readTimeout(this.timeout).writeTimeout(this.timeout).build();
    }

    @PreDestroy
    public void cleanup() {
        if (this.client != null) {
            this.client.shutdown();
        }
    }

    public JsonObject moderate(String modelName, String prompt) {
        ModerationRequest request = ModerationRequest.builder().model(modelName).input(prompt).build();
        ModerationResponse response = (ModerationResponse)RetryUtils.withRetry(() -> (ModerationResponse)this.client.moderation(request).execute(), (int)this.maxRetries);
        ModerationResult moderationResult = (ModerationResult)response.results().get(0);
        CategoryScores categoryScores = moderationResult.categoryScores();
        Categories categoryFlags = moderationResult.categories();
        JsonObject result = new JsonObject();
        result.put("flagged", (Object)moderationResult.isFlagged());
        JsonArray categories = new JsonArray();
        this.addCategoryScore(categories, "sexual", categoryScores.sexual(), categoryFlags.sexual());
        this.addCategoryScore(categories, "hate", categoryScores.hate(), categoryFlags.hate());
        this.addCategoryScore(categories, "hate-threatening", categoryScores.hateThreatening(), categoryFlags.hateThreatening());
        this.addCategoryScore(categories, "self-harm", categoryScores.selfHarm(), categoryFlags.selfHarm());
        this.addCategoryScore(categories, "violence", categoryScores.violence(), categoryFlags.violence());
        this.addCategoryScore(categories, "violence-graphic", categoryScores.violenceGraphic(), categoryFlags.violenceGraphic());
        this.addCategoryScore(categories, "sexual-minors", categoryScores.sexualMinors(), categoryFlags.sexualMinors());
        result.put("categories", (Object)categories);
        return result;
    }

    private void addCategoryScore(JsonArray categories, String name, Double score, Boolean flagged) {
        if (score != null) {
            JsonObject categoryScore = new JsonObject();
            categoryScore.put("name", (Object)name);
            categoryScore.put("flagged", (Object)flagged);
            categoryScore.put("score", (Object)score);
            categories.add((Object)categoryScore);
        }
    }
}

