/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.openai.runtime;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.DisabledChatModel;
import dev.langchain4j.model.chat.DisabledStreamingChatModel;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.embedding.DisabledEmbeddingModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.image.DisabledImageModel;
import dev.langchain4j.model.image.ImageModel;
import dev.langchain4j.model.moderation.DisabledModerationModel;
import dev.langchain4j.model.moderation.ModerationModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.openai.OpenAiEmbeddingModel;
import dev.langchain4j.model.openai.OpenAiModerationModel;
import dev.langchain4j.model.openai.OpenAiStreamingChatModel;
import io.quarkiverse.langchain4j.openai.QuarkusOpenAiChatModelBuilderFactory;
import io.quarkiverse.langchain4j.openai.QuarkusOpenAiEmbeddingModelBuilderFactory;
import io.quarkiverse.langchain4j.openai.QuarkusOpenAiImageModel;
import io.quarkiverse.langchain4j.openai.QuarkusOpenAiModerationModelBuilderFactory;
import io.quarkiverse.langchain4j.openai.QuarkusOpenAiStreamingChatModelBuilderFactory;
import io.quarkiverse.langchain4j.openai.common.QuarkusOpenAiClient;
import io.quarkiverse.langchain4j.openai.common.runtime.AdditionalPropertiesHack;
import io.quarkiverse.langchain4j.openai.runtime.config.ChatModelConfig;
import io.quarkiverse.langchain4j.openai.runtime.config.EmbeddingModelConfig;
import io.quarkiverse.langchain4j.openai.runtime.config.ImageModelConfig;
import io.quarkiverse.langchain4j.openai.runtime.config.LangChain4jOpenAiConfig;
import io.quarkiverse.langchain4j.openai.runtime.config.ModerationModelConfig;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkiverse.langchain4j.runtime.OptionalUtil;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.config.ConfigValidationException;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@Recorder
public class OpenAiRecorder {
    private static final TypeLiteral<Instance<ChatModelListener>> CHAT_MODEL_LISTENER_TYPE_LITERAL = new TypeLiteral<Instance<ChatModelListener>>(){};
    private static final String DUMMY_KEY = "dummy";
    private static final String OPENAI_BASE_URL = "https://api.openai.com/v1/";
    private final RuntimeValue<LangChain4jOpenAiConfig> runtimeConfig;

    public OpenAiRecorder(RuntimeValue<LangChain4jOpenAiConfig> runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    public Function<SyntheticCreationalContext<ChatModel>, ChatModel> chatModel(String configName) {
        LangChain4jOpenAiConfig.OpenAiConfig openAiConfig = this.correspondingOpenAiConfig((LangChain4jOpenAiConfig)this.runtimeConfig.getValue(), configName);
        if (openAiConfig.enableIntegration().booleanValue()) {
            String apiKey = openAiConfig.apiKey();
            if (DUMMY_KEY.equals(apiKey) && OPENAI_BASE_URL.equals(openAiConfig.baseUrl())) {
                throw new ConfigValidationException(this.createApiKeyConfigProblems(configName));
            }
            ChatModelConfig chatModelConfig = openAiConfig.chatModel();
            final QuarkusOpenAiChatModelBuilderFactory.Builder builder = (QuarkusOpenAiChatModelBuilderFactory.Builder)OpenAiChatModel.builder();
            builder.tlsConfigurationName(openAiConfig.tlsConfigurationName().orElse(null)).configName(configName).baseUrl(openAiConfig.baseUrl()).apiKey(apiKey).timeout(openAiConfig.timeout().orElse(Duration.ofSeconds(10L))).maxRetries(openAiConfig.maxRetries()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logRequests(), openAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logResponses(), openAiConfig.logResponses()})).modelName(chatModelConfig.modelName()).temperature(chatModelConfig.temperature()).topP(chatModelConfig.topP()).presencePenalty(chatModelConfig.presencePenalty()).frequencyPenalty(chatModelConfig.frequencyPenalty()).responseFormat((String)chatModelConfig.responseFormat().orElse(null)).strictJsonSchema((Boolean)chatModelConfig.strictJsonSchema().orElse(null)).stop((List)chatModelConfig.stop().orElse(null));
            openAiConfig.organizationId().ifPresent(arg_0 -> ((QuarkusOpenAiChatModelBuilderFactory.Builder)builder).organizationId(arg_0));
            openAiConfig.proxyHost().ifPresent(host -> builder.proxy(new Proxy(Proxy.Type.valueOf(openAiConfig.proxyType()), new InetSocketAddress((String)host, (int)openAiConfig.proxyPort()))));
            if (chatModelConfig.maxTokens().isPresent()) {
                builder.maxTokens(chatModelConfig.maxTokens().get());
            }
            return new Function<SyntheticCreationalContext<ChatModel>, ChatModel>(this){
                final /* synthetic */ OpenAiRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ChatModel apply(SyntheticCreationalContext<ChatModel> context) {
                    builder.listeners(((Instance)context.getInjectedReference(CHAT_MODEL_LISTENER_TYPE_LITERAL, new Annotation[0])).stream().collect(Collectors.toList()));
                    return builder.build();
                }
            };
        }
        return new Function<SyntheticCreationalContext<ChatModel>, ChatModel>(){

            @Override
            public ChatModel apply(SyntheticCreationalContext<ChatModel> context) {
                return new DisabledChatModel();
            }
        };
    }

    public Function<SyntheticCreationalContext<StreamingChatModel>, StreamingChatModel> streamingChatModel(String configName) {
        LangChain4jOpenAiConfig.OpenAiConfig openAiConfig = this.correspondingOpenAiConfig((LangChain4jOpenAiConfig)this.runtimeConfig.getValue(), configName);
        if (openAiConfig.enableIntegration().booleanValue()) {
            String apiKey = openAiConfig.apiKey();
            if (DUMMY_KEY.equals(apiKey) && OPENAI_BASE_URL.equals(openAiConfig.baseUrl())) {
                throw new ConfigValidationException(this.createApiKeyConfigProblems(configName));
            }
            ChatModelConfig chatModelConfig = openAiConfig.chatModel();
            final QuarkusOpenAiStreamingChatModelBuilderFactory.Builder builder = (QuarkusOpenAiStreamingChatModelBuilderFactory.Builder)OpenAiStreamingChatModel.builder();
            builder.tlsConfigurationName(openAiConfig.tlsConfigurationName().orElse(null)).configName(configName).baseUrl(openAiConfig.baseUrl()).apiKey(apiKey).timeout(openAiConfig.timeout().orElse(Duration.ofSeconds(10L))).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logRequests(), openAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logResponses(), openAiConfig.logResponses()})).modelName(chatModelConfig.modelName()).temperature(chatModelConfig.temperature()).topP(chatModelConfig.topP()).presencePenalty(chatModelConfig.presencePenalty()).frequencyPenalty(chatModelConfig.frequencyPenalty()).responseFormat((String)chatModelConfig.responseFormat().orElse(null)).stop((List)chatModelConfig.stop().orElse(null));
            openAiConfig.organizationId().ifPresent(arg_0 -> ((QuarkusOpenAiStreamingChatModelBuilderFactory.Builder)builder).organizationId(arg_0));
            openAiConfig.proxyHost().ifPresent(host -> builder.proxy(new Proxy(Proxy.Type.valueOf(openAiConfig.proxyType()), new InetSocketAddress((String)host, (int)openAiConfig.proxyPort()))));
            if (chatModelConfig.maxTokens().isPresent()) {
                builder.maxTokens(chatModelConfig.maxTokens().get());
            }
            return new Function<SyntheticCreationalContext<StreamingChatModel>, StreamingChatModel>(this){
                final /* synthetic */ OpenAiRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public StreamingChatModel apply(SyntheticCreationalContext<StreamingChatModel> context) {
                    builder.listeners(((Instance)context.getInjectedReference(CHAT_MODEL_LISTENER_TYPE_LITERAL, new Annotation[0])).stream().collect(Collectors.toList()));
                    return builder.build();
                }
            };
        }
        return new Function<SyntheticCreationalContext<StreamingChatModel>, StreamingChatModel>(){

            @Override
            public StreamingChatModel apply(SyntheticCreationalContext<StreamingChatModel> streamingChatLanguageModelSyntheticCreationalContext) {
                return new DisabledStreamingChatModel();
            }
        };
    }

    public Supplier<EmbeddingModel> embeddingModel(String configName) {
        LangChain4jOpenAiConfig.OpenAiConfig openAiConfig = this.correspondingOpenAiConfig((LangChain4jOpenAiConfig)this.runtimeConfig.getValue(), configName);
        if (openAiConfig.enableIntegration().booleanValue()) {
            String apiKey = openAiConfig.apiKey();
            if (DUMMY_KEY.equals(apiKey) && OPENAI_BASE_URL.equals(openAiConfig.baseUrl())) {
                throw new ConfigValidationException(this.createApiKeyConfigProblems(configName));
            }
            EmbeddingModelConfig embeddingModelConfig = openAiConfig.embeddingModel();
            final QuarkusOpenAiEmbeddingModelBuilderFactory.Builder builder = (QuarkusOpenAiEmbeddingModelBuilderFactory.Builder)OpenAiEmbeddingModel.builder();
            builder.tlsConfigurationName(openAiConfig.tlsConfigurationName().orElse(null)).configName(configName).baseUrl(openAiConfig.baseUrl()).apiKey(apiKey).timeout(openAiConfig.timeout().orElse(Duration.ofSeconds(10L))).maxRetries(openAiConfig.maxRetries()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{embeddingModelConfig.logRequests(), openAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{embeddingModelConfig.logResponses(), openAiConfig.logResponses()})).modelName(embeddingModelConfig.modelName());
            if (embeddingModelConfig.user().isPresent()) {
                builder.user(embeddingModelConfig.user().get());
            }
            openAiConfig.organizationId().ifPresent(arg_0 -> ((QuarkusOpenAiEmbeddingModelBuilderFactory.Builder)builder).organizationId(arg_0));
            openAiConfig.proxyHost().ifPresent(host -> builder.proxy(new Proxy(Proxy.Type.valueOf(openAiConfig.proxyType()), new InetSocketAddress((String)host, (int)openAiConfig.proxyPort()))));
            return new Supplier<EmbeddingModel>(this){
                final /* synthetic */ OpenAiRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public EmbeddingModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<EmbeddingModel>(){

            @Override
            public EmbeddingModel get() {
                return new DisabledEmbeddingModel();
            }
        };
    }

    public Supplier<ModerationModel> moderationModel(String configName) {
        LangChain4jOpenAiConfig.OpenAiConfig openAiConfig = this.correspondingOpenAiConfig((LangChain4jOpenAiConfig)this.runtimeConfig.getValue(), configName);
        if (openAiConfig.enableIntegration().booleanValue()) {
            String apiKey = openAiConfig.apiKey();
            if (DUMMY_KEY.equals(apiKey) && OPENAI_BASE_URL.equals(openAiConfig.baseUrl())) {
                throw new ConfigValidationException(this.createApiKeyConfigProblems(configName));
            }
            ModerationModelConfig moderationModelConfig = openAiConfig.moderationModel();
            final QuarkusOpenAiModerationModelBuilderFactory.Builder builder = (QuarkusOpenAiModerationModelBuilderFactory.Builder)OpenAiModerationModel.builder();
            builder.tlsConfigurationName(openAiConfig.tlsConfigurationName().orElse(null)).configName(configName).baseUrl(openAiConfig.baseUrl()).apiKey(apiKey).timeout(openAiConfig.timeout().orElse(Duration.ofSeconds(10L))).maxRetries(openAiConfig.maxRetries()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{moderationModelConfig.logRequests(), openAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{moderationModelConfig.logResponses(), openAiConfig.logResponses()})).modelName(moderationModelConfig.modelName());
            openAiConfig.organizationId().ifPresent(arg_0 -> ((QuarkusOpenAiModerationModelBuilderFactory.Builder)builder).organizationId(arg_0));
            openAiConfig.proxyHost().ifPresent(host -> builder.proxy(new Proxy(Proxy.Type.valueOf(openAiConfig.proxyType()), new InetSocketAddress((String)host, (int)openAiConfig.proxyPort()))));
            return new Supplier<ModerationModel>(this){
                final /* synthetic */ OpenAiRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ModerationModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<ModerationModel>(){

            @Override
            public ModerationModel get() {
                return new DisabledModerationModel();
            }
        };
    }

    public Supplier<ImageModel> imageModel(String configName) {
        LangChain4jOpenAiConfig.OpenAiConfig openAiConfig = this.correspondingOpenAiConfig((LangChain4jOpenAiConfig)this.runtimeConfig.getValue(), configName);
        if (openAiConfig.enableIntegration().booleanValue()) {
            String apiKey = openAiConfig.apiKey();
            if (DUMMY_KEY.equals(apiKey) && OPENAI_BASE_URL.equals(openAiConfig.baseUrl())) {
                throw new ConfigValidationException(this.createApiKeyConfigProblems(configName));
            }
            ImageModelConfig imageModelConfig = openAiConfig.imageModel();
            final QuarkusOpenAiImageModel.Builder builder = QuarkusOpenAiImageModel.builder().configName(configName).tlsConfigurationName(openAiConfig.tlsConfigurationName().orElse(null)).baseUrl(openAiConfig.baseUrl()).apiKey(apiKey).timeout(openAiConfig.timeout().orElse(Duration.ofSeconds(10L))).maxRetries(openAiConfig.maxRetries()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{imageModelConfig.logRequests(), openAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{imageModelConfig.logResponses(), openAiConfig.logResponses()})).modelName(imageModelConfig.modelName()).size(imageModelConfig.size()).quality(imageModelConfig.quality()).style(imageModelConfig.style()).responseFormat(imageModelConfig.responseFormat()).user(imageModelConfig.user());
            openAiConfig.organizationId().ifPresent(builder::organizationId);
            Optional<Path> persistDirectory = Optional.empty();
            if (imageModelConfig.persist().isPresent()) {
                if (imageModelConfig.persist().get().booleanValue()) {
                    persistDirectory = imageModelConfig.persistDirectory().or((Supplier<Optional<Path>>)new Supplier<Optional<? extends Path>>(){

                        @Override
                        public Optional<? extends Path> get() {
                            return Optional.of(Paths.get(System.getProperty("java.io.tmpdir"), "dall-e-images"));
                        }
                    });
                }
            } else if (imageModelConfig.persistDirectory().isPresent()) {
                persistDirectory = imageModelConfig.persistDirectory();
            }
            builder.persistDirectory(persistDirectory);
            return new Supplier<ImageModel>(this){
                final /* synthetic */ OpenAiRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ImageModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<ImageModel>(){

            @Override
            public ImageModel get() {
                return new DisabledImageModel();
            }
        };
    }

    private LangChain4jOpenAiConfig.OpenAiConfig correspondingOpenAiConfig(LangChain4jOpenAiConfig runtimeConfig, String configName) {
        LangChain4jOpenAiConfig.OpenAiConfig openAiConfig = NamedConfigUtil.isDefault((String)configName) ? runtimeConfig.defaultConfig() : runtimeConfig.namedConfig().get(configName);
        return openAiConfig;
    }

    private ConfigValidationException.Problem[] createApiKeyConfigProblems(String configName) {
        return this.createConfigProblems("api-key", configName);
    }

    private ConfigValidationException.Problem[] createConfigProblems(String key, String configName) {
        return new ConfigValidationException.Problem[]{this.createConfigProblem(key, configName)};
    }

    private ConfigValidationException.Problem createConfigProblem(String key, String configName) {
        return new ConfigValidationException.Problem(String.format("SRCFG00014: The config property quarkus.langchain4j.openai%s%s is required but it could not be found in any config source", NamedConfigUtil.isDefault((String)configName) ? "." : "." + configName + ".", key));
    }

    public void cleanUp(ShutdownContext shutdown) {
        AdditionalPropertiesHack.reset();
        shutdown.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                QuarkusOpenAiClient.clearCache();
            }
        });
    }
}

