/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.openai.runtime.cost;

import io.quarkiverse.langchain4j.cost.CostEstimator;
import jakarta.annotation.Priority;
import jakarta.inject.Singleton;
import java.math.BigDecimal;

@Priority(value=-2147483648)
@Singleton
public class BasicE3BigCostEstimator
implements CostEstimator {
    private static final BigDecimal COST = new BigDecimal("0.13").divide(BigDecimal.valueOf(1000000L));

    public boolean supports(CostEstimator.SupportsContext context) {
        return "text-embedding-3-large".equals(context.model());
    }

    public CostEstimator.CostResult estimate(CostEstimator.CostContext context) {
        Integer inputTokens = context.inputTokens();
        return new CostEstimator.CostResult(COST.multiply(BigDecimal.valueOf(inputTokens.intValue())), BigDecimal.ZERO, "USD");
    }
}

