/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.pgvector;

import com.pgvector.PGvector;
import io.agroal.api.AgroalPoolInterceptor;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class PgVectorAgroalPoolInterceptor
implements AgroalPoolInterceptor {
    public void onConnectionCreate(Connection connection) {
        try (Statement statement = connection.createStatement();){
            if (ConfigUtils.isProfileActive((String)"dev") || ConfigUtils.isProfileActive((String)"test")) {
                statement.executeUpdate("CREATE EXTENSION IF NOT EXISTS vector");
            }
            PGvector.addVectorType((Connection)connection);
        }
        catch (SQLException exception) {
            if (exception.getMessage().contains("could not open extension control file")) {
                throw new RuntimeException("The PostgreSQL server does not seem to support pgvector.If using containers we suggest to use pgvector/pgvector:pg16 image");
            }
            throw new RuntimeException(exception);
        }
    }
}

