/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.pinecone;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.store.embedding.EmbeddingStore;
import io.quarkiverse.langchain4j.deployment.EmbeddingStoreBuildItem;
import io.quarkiverse.langchain4j.pinecone.PineconeEmbeddingStore;
import io.quarkiverse.langchain4j.pinecone.runtime.PineconeConfig;
import io.quarkiverse.langchain4j.pinecone.runtime.PineconeRecorder;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderOverrideBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterOverrideBuildItem;
import jakarta.enterprise.context.ApplicationScoped;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class PineconeProcessor {
    public static final DotName PINECONE_EMBEDDING_STORE = DotName.createSimple(PineconeEmbeddingStore.class);
    private static final String FEATURE = "langchain4j-pinecone";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void createBean(BuildProducer<SyntheticBeanBuildItem> beanProducer, PineconeRecorder recorder, PineconeConfig config, BuildProducer<EmbeddingStoreBuildItem> embeddingStoreProducer) {
        beanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)PINECONE_EMBEDDING_STORE).types(new Type[]{ClassType.create(EmbeddingStore.class), ParameterizedType.create(EmbeddingStore.class, (Type[])new Type[]{ClassType.create(TextSegment.class)})})).defaultBean()).setRuntimeInit().unremovable()).scope(ApplicationScoped.class)).supplier(recorder.pineconeStoreSupplier(config)).done());
        embeddingStoreProducer.produce((BuildItem)new EmbeddingStoreBuildItem());
    }

    @BuildStep
    public void deprioritizeJsonb(Capabilities capabilities, BuildProducer<MessageBodyReaderOverrideBuildItem> readerOverrideProducer, BuildProducer<MessageBodyWriterOverrideBuildItem> writerOverrideProducer) {
        if (capabilities.isPresent("io.quarkus.rest.client.reactive.json.jsonb")) {
            readerOverrideProducer.produce((BuildItem)new MessageBodyReaderOverrideBuildItem("org.jboss.resteasy.reactive.server.jsonb.JsonbMessageBodyReader", 5001, true));
            writerOverrideProducer.produce((BuildItem)new MessageBodyWriterOverrideBuildItem("org.jboss.resteasy.reactive.server.jsonb.JsonbMessageBodyWriter", 5001, true));
        }
    }
}

